/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.transpiler;

import java.util.HashMap;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.codelist.IPSAppCodeList;
import net.ibizsys.model.app.dataentity.IPSAppDEACMode;
import net.ibizsys.model.app.dataentity.IPSAppDEAction;
import net.ibizsys.model.app.dataentity.IPSAppDEDataSet;
import net.ibizsys.model.app.dataentity.IPSAppDEMethod;
import net.ibizsys.model.app.dataentity.IPSAppDEUIAction;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.drctrl.IPSDEDRCtrl;
import net.ibizsys.model.control.form.IPSDEForm;
import net.ibizsys.model.control.grid.IPSDEGrid;
import net.ibizsys.model.control.menu.IPSAppMenu;
import net.ibizsys.model.control.toolbar.IPSDEToolbar;
import net.ibizsys.model.control.tree.IPSDETree;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDEActionLogic;
import net.ibizsys.model.util.transpiler.IPSModelListTranspiler;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.util.transpiler.IPSModelTranspiler;
import net.ibizsys.model.util.transpiler.PSModelTranspilerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSModelTranspileContext
implements IPSModelTranspileContext {
    private static final Log log = LogFactory.getLog(PSModelTranspileContext.class);
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private Map<Class<?>, IPSModelTranspiler> psModelTranspilerMap = new HashMap();
    private Map<Class<?>, IPSModelListTranspiler> psModelListTranspilerMap = new HashMap();
    private IPSSystemService iPSSystemService = null;
    private IPSModelObject compileOwner = null;

    @Override
    public Object getParam(String strKey) {
        return this.paramMap.get(strKey);
    }

    @Override
    public void setParam(String strKey, Object objValue) {
        this.paramMap.put(strKey, objValue);
    }

    public void registerPSModelTranspiler(Class<?> cls, IPSModelTranspiler iPSModelTranspiler) {
        this.psModelTranspilerMap.put(cls, iPSModelTranspiler);
    }

    public void registerPSModelListTranspiler(Class<?> cls, IPSModelListTranspiler iPSModelListTranspiler) {
        this.psModelListTranspilerMap.put(cls, iPSModelListTranspiler);
    }

    @Override
    public IPSModelTranspiler getPSModelTranspiler(Class<?> cls, boolean bTryMode) throws Exception {
        IPSModelTranspiler iPSModelTranspiler = this.psModelTranspilerMap.get(cls);
        if (iPSModelTranspiler == null) {
            iPSModelTranspiler = this.psModelListTranspilerMap.get(cls);
        }
        if (iPSModelTranspiler != null) {
            return iPSModelTranspiler;
        }
        return PSModelTranspilerFactory.getInstance().getPSModelTranspiler(cls, bTryMode);
    }

    @Override
    public IPSModelListTranspiler getPSModelListTranspiler(Class<?> cls, boolean bTryMode) throws Exception {
        IPSModelListTranspiler iPSModelListTranspiler = this.psModelListTranspilerMap.get(cls);
        if (iPSModelListTranspiler != null) {
            return iPSModelListTranspiler;
        }
        return PSModelTranspilerFactory.getInstance().getPSModelListTranspiler(cls, bTryMode);
    }

    @Override
    public String getPSModelUniqueTag(IPSModelObject iPSModelObject) throws Exception {
        return this.internalGetPSModelUniqueTag(iPSModelObject);
    }

    protected String internalGetPSModelUniqueTag(IPSModelObject iPSModelObject) throws Exception {
        if (iPSModelObject instanceof IPSDEForm || iPSModelObject instanceof IPSDEGrid || iPSModelObject instanceof IPSDEToolbar || iPSModelObject instanceof IPSDETree || iPSModelObject instanceof IPSDEDRCtrl) {
            IPSControl iPSControl = (IPSControl)iPSModelObject;
            if (iPSControl.getPSAppDataEntity() != null && iPSControl.getPSAppDataEntity().getPSDataEntity() != null) {
                return String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSControl.getPSAppDataEntity().getPSDataEntity(), (boolean)true), iPSControl.getCodeName());
            }
        } else if (iPSModelObject instanceof IPSAppDEUIAction) {
            IPSAppDEUIAction iPSAppDEUIAction = (IPSAppDEUIAction)iPSModelObject;
            if (iPSAppDEUIAction.getPSAppDataEntity() != null && iPSAppDEUIAction.getPSAppDataEntity().getPSDataEntity() != null) {
                return String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSAppDEUIAction.getPSAppDataEntity().getPSDataEntity(), (boolean)true), iPSAppDEUIAction.getCodeName());
            }
        } else if (iPSModelObject instanceof IPSDEActionLogic) {
            int nPos;
            IPSDEAction iPSDEAction = (IPSDEAction)iPSModelObject.getParentPSModelObject(IPSDEAction.class, false);
            if (!ObjectUtils.isEmpty((Object)iPSDEAction.getPreparePSDEActionLogics()) && (nPos = iPSDEAction.getPreparePSDEActionLogics().indexOf(iPSModelObject)) != -1) {
                return String.format("%1$s.prepare%2$s", this.getPSModelUniqueTag((IPSModelObject)iPSDEAction), (nPos + 1) * 100);
            }
            if (!ObjectUtils.isEmpty((Object)iPSDEAction.getCheckPSDEActionLogics()) && (nPos = iPSDEAction.getCheckPSDEActionLogics().indexOf(iPSModelObject)) != -1) {
                return String.format("%1$s.check%2$s", this.getPSModelUniqueTag((IPSModelObject)iPSDEAction), (nPos + 1) * 100);
            }
            if (!ObjectUtils.isEmpty((Object)iPSDEAction.getBeforePSDEActionLogics()) && (nPos = iPSDEAction.getBeforePSDEActionLogics().indexOf(iPSModelObject)) != -1) {
                return String.format("%1$s.before%2$s", this.getPSModelUniqueTag((IPSModelObject)iPSDEAction), (nPos + 1) * 100);
            }
            if (!ObjectUtils.isEmpty((Object)iPSDEAction.getAfterPSDEActionLogics()) && (nPos = iPSDEAction.getAfterPSDEActionLogics().indexOf(iPSModelObject)) != -1) {
                return String.format("%1$s.after%2$s", this.getPSModelUniqueTag((IPSModelObject)iPSDEAction), (nPos + 1) * 100);
            }
        } else {
            IPSAppDEACMode iPSAppDEACMode;
            IPSAppDataEntity iPSAppDataEntity;
            if (iPSModelObject instanceof IPSAppMenu) {
                IPSApplication iPSApplcation = (IPSApplication)iPSModelObject.getPSModelObject(IPSApplication.class, false);
                return String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSApplcation, (boolean)true), iPSModelObject.getCodeName());
            }
            if (iPSModelObject instanceof IPSAppCodeList) {
                IPSAppCodeList iPSAppCodeList = (IPSAppCodeList)iPSModelObject;
                if (StringUtils.hasLength((String)iPSAppCodeList.getCodeListTag())) {
                    IPSSystem iPSSystem = (IPSSystem)iPSModelObject.getParentPSModelObject(IPSSystem.class, false);
                    for (IPSCodeList iPSCodeList : iPSSystem.getAllPSCodeLists()) {
                        if (!iPSAppCodeList.getCodeListTag().equals(iPSCodeList.getCodeListTag())) continue;
                        return PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSCodeList, (boolean)true);
                    }
                }
            } else if (iPSModelObject instanceof IPSAppDEMethod) {
                IPSAppDEMethod iPSAppDEMethod = (IPSAppDEMethod)iPSModelObject;
                IPSAppDataEntity iPSAppDataEntity2 = (IPSAppDataEntity)iPSAppDEMethod.getParentPSModelObject(IPSAppDataEntity.class, false);
                if (iPSAppDataEntity2.getPSDataEntity() != null) {
                    if (PSModelEnums.AppDEMethodType.DEACTION.value.equals(iPSAppDEMethod.getMethodType())) {
                        return String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSAppDataEntity2.getPSDataEntity(), (boolean)true), iPSAppDEMethod.getCodeName());
                    }
                    if (PSModelEnums.AppDEMethodType.FETCH.value.equals(iPSAppDEMethod.getMethodType())) {
                        String strCodeName = iPSAppDEMethod.getCodeName();
                        if (StringUtils.hasLength((String)strCodeName) && strCodeName.indexOf("fetch") == 0) {
                            strCodeName = strCodeName.substring(5);
                        }
                        return String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSAppDataEntity2.getPSDataEntity(), (boolean)true), strCodeName);
                    }
                }
            } else if (iPSModelObject instanceof IPSAppDEAction) {
                IPSAppDEAction iPSAppDEAction = (IPSAppDEAction)iPSModelObject;
                IPSAppDataEntity iPSAppDataEntity3 = (IPSAppDataEntity)iPSAppDEAction.getParentPSModelObject(IPSAppDataEntity.class, false);
                if (iPSAppDataEntity3.getPSDataEntity() != null) {
                    return String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSAppDataEntity3.getPSDataEntity(), (boolean)true), iPSAppDEAction.getCodeName());
                }
            } else if (iPSModelObject instanceof IPSAppDEDataSet) {
                IPSAppDEDataSet iPSAppDEDataSet = (IPSAppDEDataSet)iPSModelObject;
                IPSAppDataEntity iPSAppDataEntity4 = (IPSAppDataEntity)iPSAppDEDataSet.getParentPSModelObject(IPSAppDataEntity.class, false);
                if (iPSAppDataEntity4.getPSDataEntity() != null) {
                    String strCodeName = iPSAppDEDataSet.getCodeName();
                    if (StringUtils.hasLength((String)strCodeName) && strCodeName.indexOf("fetch") == 0) {
                        strCodeName = strCodeName.substring(5);
                    }
                    return String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSAppDataEntity4.getPSDataEntity(), (boolean)true), strCodeName);
                }
            } else if (iPSModelObject instanceof IPSAppDEACMode && (iPSAppDataEntity = (IPSAppDataEntity)(iPSAppDEACMode = (IPSAppDEACMode)iPSModelObject).getParentPSModelObject(IPSAppDataEntity.class, false)).getPSDataEntity() != null) {
                return String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSAppDataEntity.getPSDataEntity(), (boolean)true), iPSAppDEACMode.getCodeName());
            }
        }
        return PSModelUtils.calcFullUniqueTag2((IPSModelObject)iPSModelObject, (boolean)true);
    }

    @Override
    public IPSSystemService getPSSystemService() {
        return this.iPSSystemService;
    }

    public void setPSSystemService(IPSSystemService iPSSystemService) {
        this.iPSSystemService = iPSSystemService;
    }

    @Override
    public IPSModelObject getCompileOwner() {
        return this.compileOwner;
    }

    public void setCompileOwner(IPSModelObject iPSModelObject) {
        this.compileOwner = iPSModelObject;
    }
}

