/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.util.merger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ibizsys.model.PSObjectImplBase;
import net.ibizsys.model.util.merger.IPSModelListMerger;
import net.ibizsys.model.util.merger.IPSModelMergeContext;
import net.ibizsys.model.util.merger.IPSModelMerger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class PSModelListMergerBase
implements IPSModelListMerger {
    private static final Log log = LogFactory.getLog(PSModelListMergerBase.class);
    public static ObjectMapper MAPPER = new ObjectMapper();
    public static final ObjectNode EMPTYNODE = new ObjectMapper().createObjectNode();

    @Override
    public void mergeSingle(IPSModelMergeContext iPSModelMergeContext, ObjectNode objectNode, ObjectNode mergeObjectNode, String strFieldName) throws Exception {
        if (!iPSModelMergeContext.logMerge(objectNode, strFieldName)) {
            return;
        }
        if (this.isEnableMergeSingle(iPSModelMergeContext)) {
            JsonNode mergeJsonNode = mergeObjectNode.get(strFieldName);
            ObjectNode mergeNode = null;
            if (mergeJsonNode instanceof ObjectNode) {
                mergeNode = (ObjectNode)mergeJsonNode;
            }
            JsonNode jsonNode = objectNode.get(strFieldName);
            ObjectNode node = null;
            if (jsonNode instanceof ObjectNode) {
                node = (ObjectNode)jsonNode;
            } else {
                if (mergeNode == null) {
                    return;
                }
                node = (ObjectNode)objectNode.set(strFieldName, (JsonNode)mergeNode);
                mergeNode = null;
            }
            ObjectNode realObjectNode = this.getRealObjectNode(iPSModelMergeContext, node);
            if (realObjectNode != null) {
                ObjectNode realMergeObjectNode = null;
                if (mergeNode != null) {
                    realMergeObjectNode = null;
                    this.getRealMergeObjectNode(iPSModelMergeContext, mergeNode);
                }
                if (realMergeObjectNode == null) {
                    realMergeObjectNode = EMPTYNODE;
                }
                this.mergeRealItem(iPSModelMergeContext, realObjectNode, realMergeObjectNode, true);
            }
        }
    }

    @Override
    public void merge(IPSModelMergeContext iPSModelMergeContext, ObjectNode objectNode, ObjectNode mergeObjectNode, String strFieldName) throws Exception {
        if (!iPSModelMergeContext.logMerge(objectNode, strFieldName)) {
            return;
        }
        if (this.isEnableMergeChild(iPSModelMergeContext)) {
            JsonNode mergeJsonNode = mergeObjectNode.get(strFieldName);
            ArrayNode mergeArrayNode = null;
            mergeArrayNode = mergeJsonNode instanceof ArrayNode ? (ArrayNode)mergeJsonNode : MAPPER.createArrayNode();
            JsonNode jsonNode = objectNode.get(strFieldName);
            ArrayNode arrayNode = null;
            if (jsonNode instanceof ArrayNode) {
                arrayNode = (ArrayNode)jsonNode;
            } else {
                if (mergeArrayNode.size() == 0) {
                    return;
                }
                arrayNode = objectNode.putArray(strFieldName);
            }
            this.onMerge(iPSModelMergeContext, arrayNode, mergeArrayNode, objectNode, mergeObjectNode, strFieldName);
        } else {
            JsonNode jsonNode = objectNode.get(strFieldName);
            ArrayNode arrayNode = null;
            if (jsonNode instanceof ArrayNode) {
                arrayNode = (ArrayNode)jsonNode;
            }
            if (arrayNode == null || arrayNode.size() == 0) {
                return;
            }
            for (int i = 0; i < arrayNode.size(); ++i) {
                ObjectNode node = (ObjectNode)arrayNode.get(i);
                ObjectNode realObjectNode = this.getRealObjectNode(iPSModelMergeContext, node);
                if (realObjectNode == null) continue;
                this.mergeRealItem(iPSModelMergeContext, realObjectNode, EMPTYNODE, true);
            }
        }
    }

    protected void onMerge(IPSModelMergeContext iPSModelMergeContext, ArrayNode arrayNode, ArrayNode mergeArrayNode, ObjectNode objectNode, ObjectNode mergeObjectNode, String strFieldName) throws Exception {
        if (this.isAppendChildOnly(iPSModelMergeContext)) {
            int i;
            for (i = 0; i < mergeArrayNode.size(); ++i) {
                ObjectNode mergeNode = (ObjectNode)mergeArrayNode.get(i);
                arrayNode.add((JsonNode)mergeNode);
            }
            for (i = 0; i < arrayNode.size(); ++i) {
                ObjectNode node = (ObjectNode)arrayNode.get(i);
                ObjectNode realObjectNode = this.getRealObjectNode(iPSModelMergeContext, node);
                if (realObjectNode == null) continue;
                this.mergeRealItem(iPSModelMergeContext, realObjectNode, EMPTYNODE, true);
            }
        } else {
            String strId;
            int i;
            LinkedHashMap<String, ObjectNode> map = new LinkedHashMap<String, ObjectNode>();
            for (i = 0; i < arrayNode.size(); ++i) {
                ObjectNode node = (ObjectNode)arrayNode.get(i);
                strId = this.getTag(iPSModelMergeContext, node).toUpperCase();
                if (map.containsKey(strId)) {
                    throw new Exception(String.format("\u5bf9\u8c61[%1$s]\u51fa\u73b0\u91cd\u590d\u6807\u8bb0", node.toPrettyString()));
                }
                map.put(strId, node);
            }
            for (i = 0; i < mergeArrayNode.size(); ++i) {
                ObjectNode mergeNode = (ObjectNode)mergeArrayNode.get(i);
                strId = this.getTag(iPSModelMergeContext, mergeNode).toUpperCase();
                ObjectNode node = (ObjectNode)map.remove(strId);
                if (node != null) {
                    ObjectNode realObjectNode = this.getRealObjectNode(iPSModelMergeContext, node);
                    ObjectNode realMergeObjectNode = this.getRealMergeObjectNode(iPSModelMergeContext, mergeNode);
                    if (realObjectNode != null && realMergeObjectNode != null) {
                        this.mergeRealItem(iPSModelMergeContext, realObjectNode, realMergeObjectNode, true);
                        continue;
                    }
                    if (realObjectNode == null && realMergeObjectNode == null) {
                        this.mergeRealItem(iPSModelMergeContext, node, mergeNode, false);
                        continue;
                    }
                    throw new Exception(String.format("\u5bf9\u8c61\u6a21\u5f0f\u4e0d\u4e00\u81f4[%1$s][%1$s]", node.toPrettyString(), mergeNode.toPrettyString()));
                }
                ObjectNode realMergeObjectNode = this.getRealMergeObjectNode(iPSModelMergeContext, mergeNode);
                if (realMergeObjectNode != null) {
                    this.mergeRealItem(iPSModelMergeContext, realMergeObjectNode, EMPTYNODE, true);
                }
                arrayNode.add((JsonNode)mergeNode);
            }
            for (Map.Entry entry : map.entrySet()) {
                ObjectNode node = (ObjectNode)entry.getValue();
                ObjectNode realObjectNode = this.getRealObjectNode(iPSModelMergeContext, node);
                if (realObjectNode == null) continue;
                this.mergeRealItem(iPSModelMergeContext, realObjectNode, EMPTYNODE, true);
            }
        }
    }

    protected void mergeRealItem(IPSModelMergeContext iPSModelMergeContext, ObjectNode objectNode, ObjectNode mergeObjectNode, boolean bRefData) throws Exception {
        if (bRefData) {
            String strModelPath = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"dynaModelFilePath", null);
            if (!StringUtils.hasLength((String)strModelPath) && StringUtils.hasLength((String)(strModelPath = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"id", null))) && strModelPath.indexOf(".json") == -1) {
                strModelPath = null;
            }
            File modelFile = null;
            if (StringUtils.hasLength((String)strModelPath)) {
                modelFile = new File(iPSModelMergeContext.getDstPSModelFolderPath() + File.separator + strModelPath);
            }
            IPSModelMerger iPSModelMerger = this.getPSModelMerger(iPSModelMergeContext, objectNode);
            iPSModelMerger.merge(iPSModelMergeContext, objectNode, mergeObjectNode);
            if (modelFile != null && !modelFile.exists()) {
                modelFile.getParentFile().mkdirs();
                try (FileOutputStream os = new FileOutputStream(modelFile);){
                    MAPPER.writerWithDefaultPrettyPrinter().writeValue((OutputStream)os, (Object)objectNode);
                }
            }
        } else {
            if (PSObjectImplBase.getBoolean((ObjectNode)objectNode, (String)"modelref", (boolean)false)) {
                return;
            }
            IPSModelMerger iPSModelMerger = this.getPSModelMerger(iPSModelMergeContext, objectNode);
            iPSModelMerger.merge(iPSModelMergeContext, objectNode, mergeObjectNode);
        }
    }

    protected String getTag(IPSModelMergeContext iPSModelMergeContext, ObjectNode objectNode) throws Exception {
        String strTag;
        if (PSObjectImplBase.getBoolean((ObjectNode)objectNode, (String)"modelref", (boolean)false)) {
            String strTag2 = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"path", null);
            if (!StringUtils.hasLength((String)strTag2) && !StringUtils.hasLength((String)(strTag2 = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"id", null)))) {
                throw new Exception("\u65e0\u6cd5\u8ba1\u7b97\u6a21\u578b\u6807\u8bc6");
            }
            return strTag2;
        }
        String strTagField = this.getTagField(iPSModelMergeContext);
        if (StringUtils.hasLength((String)strTagField)) {
            String[] fields = strTagField.split("[;]");
            if (fields.length == 1) {
                String strTag3 = PSObjectImplBase.getString((ObjectNode)objectNode, (String)strTagField, null);
                if (StringUtils.hasLength((String)strTag3)) {
                    return strTag3;
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < fields.length; ++i) {
                    sb.append(String.format("-%1$s", PSObjectImplBase.getString((ObjectNode)objectNode, (String)fields[i], null)));
                }
                return sb.toString();
            }
        }
        if (StringUtils.hasLength((String)(strTag = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"id", null)))) {
            return strTag;
        }
        strTag = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"dynaModelFilePath", null);
        if (StringUtils.hasLength((String)strTag)) {
            return strTag;
        }
        strTag = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"codeName", null);
        if (StringUtils.hasLength((String)strTag)) {
            return strTag;
        }
        strTag = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"name", null);
        if (StringUtils.hasLength((String)strTag)) {
            return strTag;
        }
        throw new Exception("\u65e0\u6cd5\u8ba1\u7b97\u6a21\u578b\u6807\u8bc6");
    }

    protected String getTagField(IPSModelMergeContext iPSModelMergeContext) {
        return null;
    }

    protected boolean isAppendChildOnly(IPSModelMergeContext iPSModelMergeContext) {
        return false;
    }

    protected boolean isEnableMergeChild(IPSModelMergeContext iPSModelMergeContext) {
        return true;
    }

    protected boolean isEnableMergeSingle(IPSModelMergeContext iPSModelMergeContext) {
        return false;
    }

    protected ObjectNode getRealObjectNode(IPSModelMergeContext iPSModelMergeContext, ObjectNode objectNode) throws Exception {
        if (PSObjectImplBase.getBoolean((ObjectNode)objectNode, (String)"modelref", (boolean)false)) {
            String strPath = PSObjectImplBase.getString((ObjectNode)objectNode, (String)"path", null);
            if (StringUtils.hasLength((String)strPath)) {
                String strFullModelPath = iPSModelMergeContext.getPSModelFolderPath() + File.separator + strPath;
                File modelFile = new File(strFullModelPath);
                if (modelFile.exists()) {
                    return (ObjectNode)MAPPER.readTree(new File(strFullModelPath));
                }
                strFullModelPath = iPSModelMergeContext.getMergePSModelFolderPath() + File.separator + strPath;
                modelFile = new File(strFullModelPath);
                if (modelFile.exists()) {
                    return (ObjectNode)MAPPER.readTree(new File(strFullModelPath));
                }
            }
            return null;
        }
        return objectNode;
    }

    protected ObjectNode getRealMergeObjectNode(IPSModelMergeContext iPSModelMergeContext, ObjectNode mergeObjectNode) throws Exception {
        if (PSObjectImplBase.getBoolean((ObjectNode)mergeObjectNode, (String)"modelref", (boolean)false)) {
            String strPath = PSObjectImplBase.getString((ObjectNode)mergeObjectNode, (String)"path", null);
            if (StringUtils.hasLength((String)strPath)) {
                String strFullModelPath = iPSModelMergeContext.getMergePSModelFolderPath() + File.separator + strPath;
                return (ObjectNode)MAPPER.readTree(new File(strFullModelPath));
            }
            return null;
        }
        return mergeObjectNode;
    }

    protected abstract IPSModelMerger getPSModelMerger(IPSModelMergeContext var1, ObjectNode var2) throws Exception;
}

