package net.ibizsys.model.util.transpiler.extend.wf;

import org.springframework.util.ObjectUtils;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.model.wf.IPSWFEmbedWFProcessBase;
import net.ibizsys.model.wf.IPSWFInteractiveProcess;
import net.ibizsys.model.wf.IPSWFProcess;
import net.ibizsys.model.wf.IPSWFProcessParam;
import net.ibizsys.model.wf.IPSWFProcessRole;
import net.ibizsys.model.wf.IPSWFProcessSubWF;
import net.ibizsys.model.wf.PSWFEmbedWFProcessBaseImpl;
import net.ibizsys.model.wf.PSWFInteractiveProcessImpl;
import net.ibizsys.model.wf.PSWFProcessImpl;
import net.ibizsys.psmodel.core.domain.PSWFProcParam;
import net.ibizsys.psmodel.core.domain.PSWFProcRole;
import net.ibizsys.psmodel.core.domain.PSWFProcSubWF;
import net.ibizsys.psmodel.core.domain.PSWFProcess;
import net.ibizsys.psmodel.core.util.IPSModel;

public class PSWFProcessListTranspilerEx extends net.ibizsys.model.util.transpiler.wf.PSWFProcessListTranspiler{
	
	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
		if(bFullMode) {
			IPSWFProcess iPSWFProcess = (IPSWFProcess)iPSModelObject;
			PSWFProcess psWFProcess = (PSWFProcess)domain;
			
			if(iPSWFProcess.getPSWFProcessParams()!=null) {
				iPSModelTranspileContext.getPSModelListTranspiler(IPSWFProcessParam.class, false).decompile(iPSModelTranspileContext, iPSWFProcess.getPSWFProcessParams(), psWFProcess.getPSWFProcParamsIf(), bFullMode);
				int nOrder = 100;
				for(PSWFProcParam child : psWFProcess.getPSWFProcParamsIf()) {
					child.setPSWFProcessId(psWFProcess.getId());
					child.setPSWFProcessName(psWFProcess.getName());
//					child.setOrderValue(nOrder);
//					nOrder += 100;
				}
			}
			
			if(iPSWFProcess instanceof IPSWFInteractiveProcess) {
				IPSWFInteractiveProcess iPSWFInteractiveProcess = (IPSWFInteractiveProcess)iPSWFProcess;
				if(iPSWFInteractiveProcess.getPSWFProcessRoles()!=null) {
					iPSModelTranspileContext.getPSModelListTranspiler(IPSWFProcessRole.class, false).decompile(iPSModelTranspileContext, iPSWFInteractiveProcess.getPSWFProcessRoles(), psWFProcess.getPSWFProcRolesIf(), bFullMode);
					int nOrder = 100;
					for(PSWFProcRole child : psWFProcess.getPSWFProcRolesIf()) {
						child.setPSWFProcessId(psWFProcess.getId());
						child.setPSWFProcessName(psWFProcess.getName());
//						child.setOrderValue(nOrder);
//						nOrder += 100;
					}
				}
			}
			
			if(iPSWFProcess instanceof IPSWFEmbedWFProcessBase) {
				IPSWFEmbedWFProcessBase iPSWFEmbedWFProcessBase = (IPSWFEmbedWFProcessBase)iPSWFProcess;
				if(iPSWFEmbedWFProcessBase.getPSWFProcessSubWFs()!=null) {
					iPSModelTranspileContext.getPSModelListTranspiler(IPSWFProcessSubWF.class, false).decompile(iPSModelTranspileContext, iPSWFEmbedWFProcessBase.getPSWFProcessSubWFs(), psWFProcess.getPSWFProcSubWFsIf(), bFullMode);
					int nOrder = 100;
					for(PSWFProcSubWF child : psWFProcess.getPSWFProcSubWFsIf()) {
						child.setPSWFProcessId(psWFProcess.getId());
						child.setPSWFProcessName(psWFProcess.getName());
//						child.setOrderValue(nOrder);
//						nOrder += 100;
					}
				}
			}
		}
	}
	
	@Override
	protected void onCompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModel domain, ObjectNode objectNode) throws Exception {
		super.onCompile(iPSModelTranspileContext, domain, objectNode);
		
		PSWFProcess psWFProcess = (PSWFProcess)domain;
		if(!ObjectUtils.isEmpty(psWFProcess.getPSWFProcParams())) {
			ArrayNode arrayNode = objectNode.putArray(PSWFProcessImpl.ATTR_GETPSWFPROCESSPARAMS);
			iPSModelTranspileContext.getPSModelListTranspiler(IPSWFProcessParam.class, false).compile(iPSModelTranspileContext, psWFProcess.getPSWFProcParams(), arrayNode);
		}
		
		if(!ObjectUtils.isEmpty(psWFProcess.getPSWFProcRoles())) {
			ArrayNode arrayNode = objectNode.putArray(PSWFInteractiveProcessImpl.ATTR_GETPSWFPROCESSROLES);
			iPSModelTranspileContext.getPSModelListTranspiler(IPSWFProcessRole.class, false).compile(iPSModelTranspileContext, psWFProcess.getPSWFProcRoles(), arrayNode);
		}
		
		if(!ObjectUtils.isEmpty(psWFProcess.getPSWFProcSubWFs())) {
			ArrayNode arrayNode = objectNode.putArray(PSWFEmbedWFProcessBaseImpl.ATTR_GETPSWFPROCESSSUBWFS);
			iPSModelTranspileContext.getPSModelListTranspiler(IPSWFProcessSubWF.class, false).compile(iPSModelTranspileContext, psWFProcess.getPSWFProcSubWFs(), arrayNode);
		}
	}
}