package net.ibizsys.model.util.transpiler.extend.dataentity.logic;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkGroupCond;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.domain.PSDELLCond;
import net.ibizsys.psmodel.core.util.IPSModel;

public class PSDELogicLinkCondListTranspilerEx extends net.ibizsys.model.util.transpiler.dataentity.logic.PSDELogicLinkCondListTranspiler{
	
	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
		
		if(bFullMode) {
			IPSDELogicLinkCond iPSDELogicLinkCond = (IPSDELogicLinkCond)iPSModelObject;
			PSDELLCond psDELogicLinkCond = (PSDELLCond)domain;
			if(iPSDELogicLinkCond instanceof IPSDELogicLinkGroupCond) {
				IPSDELogicLinkGroupCond iPSDELogicLinkGroupCond = (IPSDELogicLinkGroupCond)iPSDELogicLinkCond;
				if(iPSDELogicLinkGroupCond.getPSDELogicLinkConds()!=null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDELogicLinkCond.class, false).decompile(iPSModelTranspileContext, iPSDELogicLinkGroupCond.getPSDELogicLinkConds(), psDELogicLinkCond.getPSDELLCondsIf(), bFullMode);
					for(PSDELLCond child : psDELogicLinkCond.getPSDELLCondsIf()) {
						child.setPPSDELLCondId(psDELogicLinkCond.getId());
						child.setPPSDELLCondName(psDELogicLinkCond.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
				}
			}
		}
	}
}