package net.ibizsys.model.util.transpiler.extend.control.form;

import java.util.ArrayList;
import java.util.List;

import org.springframework.util.StringUtils;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.IPSEditor;
import net.ibizsys.model.control.form.IPSDEFDCatGroupLogic;
import net.ibizsys.model.control.form.IPSDEFDLogic;
import net.ibizsys.model.control.form.IPSDEForm;
import net.ibizsys.model.control.form.IPSDEFormDRUIPart;
import net.ibizsys.model.control.form.IPSDEFormDetail;
import net.ibizsys.model.control.form.IPSDEFormGroupBase;
import net.ibizsys.model.control.form.IPSDEFormItem;
import net.ibizsys.model.control.form.IPSDEFormItemEx;
import net.ibizsys.model.control.form.IPSDEFormTabPanel;
import net.ibizsys.model.control.form.IPSDESearchFormItem;
import net.ibizsys.model.control.layout.IPSLayout;
import net.ibizsys.model.control.layout.IPSLayoutPos;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.domain.PSDEFDLogic;
import net.ibizsys.psmodel.core.domain.PSDEFormDetail;
import net.ibizsys.psmodel.core.util.IPSModel;

public class PSDEFormDetailListTranspilerEx extends net.ibizsys.model.util.transpiler.control.form.PSDEFormDetailListTranspiler{
	
	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		
		IPSDEFormDetail iPSDEFormDetail = (IPSDEFormDetail)iPSModelObject;
		PSDEFormDetail psDEFormDetail = (PSDEFormDetail)domain;
		
		if(iPSDEFormDetail.getPSLayout()!=null) {
			iPSModelTranspileContext.getPSModelListTranspiler(IPSLayout.class, false).decompile(iPSModelTranspileContext, iPSDEFormDetail.getPSLayout(), psDEFormDetail, bFullMode);
			psDEFormDetail.setLayoutMode(iPSDEFormDetail.getPSLayout().getLayout());
		}
		
		if(iPSDEFormDetail.getPSLayoutPos()!=null) {
			iPSModelTranspileContext.getPSModelListTranspiler(IPSLayoutPos.class, false).decompile(iPSModelTranspileContext, iPSDEFormDetail.getPSLayoutPos(), psDEFormDetail, bFullMode);
		}
		
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
		
		
		
		
		
		if(iPSDEFormDetail instanceof IPSDEFormItem) {
			IPSDEFormItem iPSDEFormItem = (IPSDEFormItem)iPSDEFormDetail;
			if(iPSDEFormItem.getPSEditor()!=null) {
				iPSModelTranspileContext.getPSModelListTranspiler(IPSEditor.class, false).decompile(iPSModelTranspileContext, iPSDEFormItem.getPSEditor(), psDEFormDetail, bFullMode);
			}
			
			if(iPSDEFormItem instanceof IPSDESearchFormItem) {
				IPSDESearchFormItem iPSDESearchFormItem = (IPSDESearchFormItem)iPSDEFormItem;
				//设置搜索模式
				String strPSDEFieldId = psDEFormDetail.getPSDEFId();
				if(StringUtils.hasLength(strPSDEFieldId)){
					
				}
			}
		}
		
		
		
		if(iPSDEFormDetail instanceof IPSDEFormDRUIPart) {
			IPSDEFormDRUIPart iPSDEFormDRUIPart = (IPSDEFormDRUIPart)iPSDEFormDetail;
			IPSDEForm iPSDEForm = iPSDEFormDRUIPart.getParentPSModelObject(IPSDEForm.class, false);
			psDEFormDetail.setPSDEDRItemId(String.format("%1$s__formdruipart__%2$s", iPSModelTranspileContext.getPSModelUniqueTag(iPSDEForm), iPSDEFormDRUIPart.getName()).toLowerCase());
			psDEFormDetail.setPSDEDRItemName(String.format("表单关系部件[%1$s][%2$s]", iPSDEForm.getCodeName(), iPSDEFormDRUIPart.getName()));
		}
		
		if(bFullMode) {
			
			if(iPSDEFormDetail.getPSDEFDGroupLogics()!=null) {
				for(IPSDEFDCatGroupLogic iPSDEFDGroupLogic :iPSDEFormDetail.getPSDEFDGroupLogics()) {
					if(iPSDEFDGroupLogic.getPSDEFDLogics()!=null) {
						int nOrder = 100;
						List<PSDEFDLogic> psDEFDLogicList = new ArrayList<PSDEFDLogic>();
						iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFDLogic.class, false).decompile(iPSModelTranspileContext, iPSDEFDGroupLogic.getPSDEFDLogics(), psDEFDLogicList, bFullMode);
						for(PSDEFDLogic child : psDEFDLogicList) {
							child.setLogicCat(iPSDEFDGroupLogic.getLogicCat());
							child.setPSDEFormDetailId(psDEFormDetail.getId());
							child.setPSDEFormDetailName(psDEFormDetail.getName());
							child.setOrderValue(nOrder);
							nOrder += 100;
						}
						psDEFormDetail.getPSDEFDLogicsIf().addAll(psDEFDLogicList);
					}
				}
			}
			
			if(iPSDEFormDetail instanceof IPSDEFormTabPanel) {
				IPSDEFormTabPanel iPSDEFormTabPanel = (IPSDEFormTabPanel)iPSDEFormDetail;
				if(iPSDEFormTabPanel.getPSDEFormTabPages()!=null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).decompile(iPSModelTranspileContext, iPSDEFormTabPanel.getPSDEFormTabPages(), psDEFormDetail.getPSDEFormDetailsIf(), bFullMode);
					for(PSDEFormDetail child : psDEFormDetail.getPSDEFormDetailsIf()) {
						child.setPPSDEFormDetailId(psDEFormDetail.getId());
						child.setPPSDEFormDetailName(psDEFormDetail.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
				}
				return;
			}
			if(iPSDEFormDetail instanceof IPSDEFormGroupBase) {
				IPSDEFormGroupBase iPSDEFormGroupBase = (IPSDEFormGroupBase)iPSDEFormDetail;
				if(iPSDEFormGroupBase.getPSDEFormDetails()!=null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).decompile(iPSModelTranspileContext, iPSDEFormGroupBase.getPSDEFormDetails(), psDEFormDetail.getPSDEFormDetailsIf(), bFullMode);
					for(PSDEFormDetail child : psDEFormDetail.getPSDEFormDetailsIf()) {
						child.setPPSDEFormDetailId(psDEFormDetail.getId());
						child.setPPSDEFormDetailName(psDEFormDetail.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
				}
				return;
			}
			if(iPSDEFormDetail instanceof IPSDEFormItemEx) {
				IPSDEFormItemEx iPSDEFormItemEx = (IPSDEFormItemEx)iPSDEFormDetail;
				if(iPSDEFormItemEx.getPSDEFormItems()!=null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFormDetail.class, false).decompile(iPSModelTranspileContext, iPSDEFormItemEx.getPSDEFormItems(), psDEFormDetail.getPSDEFormDetailsIf(), bFullMode);
					for(PSDEFormDetail child : psDEFormDetail.getPSDEFormDetailsIf()) {
						child.setPPSDEFormDetailId(psDEFormDetail.getId());
						child.setPPSDEFormDetailName(psDEFormDetail.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
				}
				return;
			}
		}
	}
}