package net.ibizsys.model.util.transpiler.extend.control.form;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.form.IPSDEFDGroupLogic;
import net.ibizsys.model.control.form.IPSDEFDLogic;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.domain.PSDEFDLogic;
import net.ibizsys.psmodel.core.util.IPSModel;

public class PSDEFDLogicListTranspilerEx extends net.ibizsys.model.util.transpiler.control.form.PSDEFDLogicListTranspiler{
	@Override
	protected void onDecompile(IPSModelTranspileContext iPSModelTranspileContext, IPSModelObject iPSModelObject, IPSModel domain, boolean bFullMode) throws Exception {
		super.onDecompile(iPSModelTranspileContext, iPSModelObject, domain, bFullMode);
		
		if(bFullMode) {
			IPSDEFDLogic iPSDEFDLogic = (IPSDEFDLogic)iPSModelObject;
			PSDEFDLogic psDEFDLogic = (PSDEFDLogic)domain;
			if(iPSDEFDLogic instanceof IPSDEFDGroupLogic) {
				IPSDEFDGroupLogic iPSDEFDGroupLogic = (IPSDEFDGroupLogic)iPSDEFDLogic;
				if(iPSDEFDGroupLogic.getPSDEFDLogics()!=null) {
					int nOrder = 100;
					iPSModelTranspileContext.getPSModelListTranspiler(IPSDEFDLogic.class, false).decompile(iPSModelTranspileContext, iPSDEFDGroupLogic.getPSDEFDLogics(), psDEFDLogic.getPSDEFDLogicsIf(), bFullMode);
					for(PSDEFDLogic child : psDEFDLogic.getPSDEFDLogicsIf()) {
						child.setPPSDEFDLogicId(psDEFDLogic.getId());
						child.setPPSDEFDLogicName(psDEFDLogic.getName());
						child.setOrderValue(nOrder);
						nOrder += 100;
					}
				}
			}
		}
	}
}