package net.ibizsys.model.util.transpiler;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystemService;

public interface IPSModelTranspileContext {

	/**
	 * 获取参数
	 * @param strKey
	 * @return
	 */
	Object getParam(String strKey);
	
	
	/**
	 * 设置参数
	 * @param strKey
	 * @param objValue
	 */
	void setParam(String strKey, Object objValue);
	
	/**
	 * 获取模型转译器
	 * @param cls
	 * @param bTryMode
	 * @return
	 * @throws Exception
	 */
	IPSModelTranspiler getPSModelTranspiler(Class<?> cls, boolean bTryMode) throws Exception;
	
	/**
	 * 获取模型列表转译器
	 * @param cls
	 * @param bTryMode
	 * @return
	 * @throws Exception
	 */
	IPSModelListTranspiler getPSModelListTranspiler(Class<?> cls, boolean bTryMode) throws Exception;
	
	
	
	
	/**
	 * 获取模型唯一标记
	 * @param iPSModelObject
	 * @return
	 * @throws Exception
	 */
	String getPSModelUniqueTag(IPSModelObject iPSModelObject) throws Exception;
	
	
	/**
	 * 获取系统运行时模型服务
	 * @return
	 */
	IPSSystemService getPSSystemService();
	
	
//	
//	/**
//	 * 设置编译所有者
//	 * @param iPSModelObject
//	 */
//	void setCompileOwner(IPSModelObject iPSModelObject);
//	
//	
	
	/**
	 * 获取编译所有者
	 * @return
	 */
	IPSModelObject getCompileOwner();
}
