package net.ibizsys.model.engine.util;

public class NavigateContextHolder {

	private static ThreadLocal<INavigateContext> actionSessionThreadLocal = new ThreadLocal<INavigateContext>();
	
	public static INavigateContext getCurrent() {
		return actionSessionThreadLocal.get();
	}
	
	public static INavigateContext getCurrentMust() throws Exception{
		INavigateContext iNavigateContext = actionSessionThreadLocal.get();
		if(iNavigateContext == null) {
			throw new Exception("当前导航上下文无效");
		}
		return iNavigateContext;
	}
	
	public static void setCurrent(INavigateContext iNavigateContext) {
		actionSessionThreadLocal.set(iNavigateContext);
	}
}
