package net.ibizsys.model.engine.util;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.model.util.DataTypeUtils;

public class JsonUtils {
	
	private static ObjectMapper Mapper = null;
	
	public static ObjectMapper getMapper() {
		if(JsonUtils.Mapper == null) {
			JsonUtils.Mapper = new ObjectMapper();
		}
		return JsonUtils.Mapper;
	}
	
	public static void setMapper(ObjectMapper mapper) {
		JsonUtils.Mapper = mapper;
	}
	
	public static ObjectNode createObjectNode() {
		return getMapper().createObjectNode();
	}
	
	public static ArrayNode createArrayNode() {
		return getMapper().createArrayNode();
	}
	
	public static String toString(Object obj) {
		try {
			return getMapper().writeValueAsString(obj);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	public static JsonNode toJsonNode(Object obj) {
		try {
			if(obj instanceof String) {
				return getMapper().readTree((String)obj);
			}
			return getMapper().convertValue(obj, JsonNode.class);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	public static ArrayNode toArrayNode(Object obj) {
		try {
			if(obj instanceof String) {
				return (ArrayNode)getMapper().readTree((String)obj);
			}
			
			
			return getMapper().convertValue(obj, ArrayNode.class);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	public static ObjectNode toObjectNode(Object obj) {
		try {
			if(obj instanceof String) {
				return (ObjectNode)getMapper().readTree((String)obj);
			}
			
			
			return getMapper().convertValue(obj, ObjectNode.class);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	
	public static Map asMap(Object obj) {
		return as(obj, Map.class);
	}
	
	public static IEntity asEntity(Object obj) {
		return as(obj, Entity.class);
	}
	
	public static List asList(Object obj) {
		return as(obj, List.class);
	}
	
	
	public static <T> T as(Object obj, Class<T> cls) {
		try {
			if(obj instanceof String) {
				return getMapper().readValue((String) obj, cls);
			}
			else {
				return getMapper().convertValue(obj, cls);
			}
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	
	public static String getField(ObjectNode objectNode, String fieldName, String defaultValue) {
		
		if(objectNode == null) {
			return defaultValue;
		}
		
		JsonNode jsonNode = objectNode.get(fieldName);
		if(jsonNode == null) {
			return defaultValue;
		}
		return jsonNode.asText(defaultValue);
	}
	
	public static boolean getField(ObjectNode objectNode, String fieldName, boolean defaultValue) {
		
		if(objectNode == null) {
			return defaultValue;
		}
		
		JsonNode jsonNode = objectNode.get(fieldName);
		if(jsonNode == null) {
			return defaultValue;
		}
		
		if(jsonNode.isBoolean()) {
			return jsonNode.asBoolean(defaultValue);
		}
		
		return DataTypeUtils.getBooleanValue(jsonNode.asText(), defaultValue);
		
		
	}
	
	public static long getField(ObjectNode objectNode, String fieldName, long defaultValue) {
		
		if(objectNode == null) {
			return defaultValue;
		}
		
		JsonNode jsonNode = objectNode.get(fieldName);
		if(jsonNode == null) {
			return defaultValue;
		}
		return jsonNode.asLong(defaultValue);
	}
	
	public static double getField(ObjectNode objectNode, String fieldName, double defaultValue) {
		
		if(objectNode == null) {
			return defaultValue;
		}
		
		JsonNode jsonNode = objectNode.get(fieldName);
		if(jsonNode == null) {
			return defaultValue;
		}
		return jsonNode.asDouble(defaultValue);
	}
	
	public static int getField(ObjectNode objectNode, String fieldName, int defaultValue) {
		
		if(objectNode == null) {
			return defaultValue;
		}
		
		JsonNode jsonNode = objectNode.get(fieldName);
		if(jsonNode == null) {
			return defaultValue;
		}
		return jsonNode.asInt(defaultValue);
	}
	
	
}
