package net.ibizsys.model.engine.util;

import java.util.Map;


public interface IEntity extends IReadOnlyEntity {

	
	/**
	 * 设置指定属性值
	 * @param name
	 * @param value
	 */
	void set(String name, Object value);
	
	
	
	/**
	 * 移除属性值
	 * @param name
	 */
	void reset(String name);
	
	
	/**
	 * 重置数据对象
	 */
	void resetAll();
	
	/**
	 * 拷贝到目标数据对象
	 * @param iEntity
	 */
	void copyTo(IEntity iEntity);
	
	
	
	/**
	 * 直接获取原始数据Map对象
	 * @return
	 */
	Map<String, Object> any();
}
