package net.ibizsys.model.engine.util;

import com.fasterxml.jackson.annotation.JsonIgnore;

import net.ibizsys.model.engine.PSModelEngineException;

public class ExceptionEntity extends EntityBase implements IExceptionEntity{

	public final static String FIELD_CODE = "code";
	public final static String FIELD_INFO = "info";
	/**
	 * Http 响应状态码
	 */
	public final static String FIELD_STATUSCODE = "statuscode";
	
	@JsonIgnore
	private Throwable throwable = null;
	
	
	public ExceptionEntity(Throwable throwable) {
		this.throwable = throwable;
		//设置参数
		if(throwable instanceof PSModelEngineException) {
			PSModelEngineException psModelEngineException = (PSModelEngineException)throwable;
			this.set(FIELD_CODE, psModelEngineException.getErrorCode());
		}
//		if(throwable instanceof ISubSysServiceAPIRuntimeException) {
//			ISubSysServiceAPIRuntimeException iSubSysServiceAPIRuntimeException = (ISubSysServiceAPIRuntimeException)throwable;
//			this.set(FIELD_STATUSCODE, iSubSysServiceAPIRuntimeException.getStatusCode());
//		}
		this.set(FIELD_INFO, throwable.getMessage());
	}

	@Override
	@JsonIgnore
	public Throwable getException() {
		return this.throwable;
	}
	
	
	public static IExceptionEntity from(Throwable throwable) {
		return new ExceptionEntity(throwable);
	}
}
