package net.ibizsys.model.engine.util;


import java.util.LinkedHashMap;
import java.util.Map;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 基础数据对象
 * 
 * @author lionlau
 *
 */
@SuppressWarnings("serial")
public abstract class EntityBase implements IEntity{

	@JsonIgnore
	private Map<String, Object> paramMap = null;

	@Override
	public Object get(String name) {
		if (!StringUtils.hasLength(name)) {
			return null;
		}

		name = getRealName(name);
		
		if (paramMap != null) {
			return paramMap.get(name);
		}
		return null;
	}

	
	@Override
	@JsonAnySetter
	public void set(String name, Object value) {
		if (!StringUtils.hasLength(name)) {
			return;
		}
		
		name = getRealName(name);
		
		if (paramMap == null) {
			paramMap = createAny();
		}

		paramMap.put(name, value);
	}

	@Override
	public boolean contains(String name) {
		if (!StringUtils.hasLength(name)) {
			return false;
		}
		
		name = getRealName(name);
		
		if (paramMap != null) {
			return paramMap.containsKey(name);
		}
		return false;
	}

	@Override
	public void reset(String name) {
		if (!StringUtils.hasLength(name)) {
			return;
		}
		
		name = getRealName(name);
		
		if (paramMap != null) {
			paramMap.remove(name);
		}
	}

	@Override
	public void resetAll() {
		onResetAll();
	}

	protected void onResetAll() {

		this.paramMap = null;

	}
	
	@JsonIgnore
	protected int getNameCaseMode() {
		return NAMECASEMODE_NONE;
	}

	protected String getRealName(String name) {
		switch(this.getNameCaseMode()) {
		case NAMECASEMODE_LOWER:
			return name.toLowerCase();
		case NAMECASEMODE_UPPER:
			return name.toUpperCase();
		default:
			return name;
		}
	}

	@Override
	public void copyTo(IEntity iEntity) {
		if (this.paramMap != null) {
			for (java.util.Map.Entry<String, Object> entry : this.paramMap.entrySet()) {
				iEntity.set(entry.getKey(), entry.getValue());
			}
		}
	}

	@JsonAnyGetter
	public Map<String, Object> any() {
		return this.paramMap;
	}
	
	@JsonIgnore
	protected void setAny(Map<String, Object> map){
		this.setAny(map, false);
	}
	
	@JsonIgnore
	protected void setAny(Map<String, Object> map, boolean bCopyMode){
		if(bCopyMode) {
			if(map == null) {
				this.paramMap = null;
			}
			else {
				this.paramMap = this.createAny();
				this.paramMap.putAll(map);
			}
		}
		else {
			this.paramMap = map;
		}
		
	}
	
	@JsonIgnore
	protected Map<String, Object> createAny(){
		return new LinkedHashMap<String, Object>();
	}
	
	@JsonIgnore
	public void putAll(Map<String, Object> map) {
		Assert.notNull(map, "传入参数无效");
		for(java.util.Map.Entry<String, Object> entry : map.entrySet()) {
			this.set(entry.getKey(), entry.getValue());
		}
	}
}
