package net.ibizsys.model.engine.util;

public class ActionSessionHolder {

	private static ThreadLocal<IActionSession> actionSessionThreadLocal = new ThreadLocal<IActionSession>();
	
	public static IActionSession getCurrent() {
		return actionSessionThreadLocal.get();
	}
	
	public static IActionSession getCurrentMust() throws Exception{
		IActionSession iActionSession = actionSessionThreadLocal.get();
		if(iActionSession == null) {
			throw new Exception("当前行为会话无效");
		}
		return iActionSession;
	}
	
	public static void setCurrent(IActionSession iActionSession) {
		actionSessionThreadLocal.set(iActionSession);
	}
}
