package net.ibizsys.model.engine.sysutil;

import net.ibizsys.model.engine.service.PSSubSysServiceAPIEngineBaseBase;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.res.IPSSysUtil;

public abstract class PSSysUtilEngineBase<M extends IPSSysUtil> extends PSSubSysServiceAPIEngineBaseBase<M> implements IPSSysUtilEngine<M> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSSysUtilEngineBase.class);
	
	private boolean installedFlag = false;
	
//	@Override
//	public IPSSysUtil getPSSysUtil() {
//		return getPSModelObject();
//	}
//	
//	@Override
//	public IPSSysUtil getPSModelObject() {
//		return (IPSSysUtil)super.getPSModelObject();
//	}
	
	@Override
	public synchronized void install() throws Exception {
		if(!this.installedFlag) {
			this.installedFlag = true;
			this.onInstall();
		}
	}
	
	
	protected void onInstall() throws Exception {
		
		
	}
	
	@Override
	public boolean isInstalled() {
		return this.installedFlag;
	}
	
	@Override
	public void uninstall() {
		try {
			if(this.installedFlag) {
				this.installedFlag = false;
				onUninstall();
			}
			
		}
		catch(Throwable ex) {
			log.error(String.format("卸载系统功能[%1$s]发生异常，%2$s", this.getName(), ex.getMessage()), ex);
			this.getPSModelEngineHolder().getPSSystemLogger().error(getLogCat(), String.format("卸载系统功能[%1$s]发生异常，%2$s", this.getName(), ex.getMessage()), null);
		}
	}
	
	protected void onUninstall() throws Throwable{
		
	}

	@Override
	public Object executeAction(String actionName, Object[] args) {
		return this.executeAction("执行操作", new IAction<Object>() {
			@Override
			public Object execute(Object[] args2) throws Throwable {
				// TODO Auto-generated method stub
				return onExecuteAction(actionName, args);
			}
		});
	}

	protected Object onExecuteAction(String actionName, Object[] args) throws Throwable{
		throw new Exception("没有实现");
	}
	
}
