package net.ibizsys.model.engine.sysutil;

import net.ibizsys.model.engine.service.IPSSubSysServiceAPIEngineBase;
import net.ibizsys.model.res.IPSSysUtil;

/**
 * 系统功能组件引擎
 * @author lionlau
 *
 */
public interface IPSSysUtilEngine<M extends IPSSysUtil> extends IPSSubSysServiceAPIEngineBase<M>{

	
//	/**
//	 * 获取系统预置功能模型对象
//	 * @return
//	 */
//	IPSSysUtil getPSSysUtil();
	
	
	/**
	 * 安装功能
	 * @throws Throwable
	 */
	void install() throws Exception;

	
	/**
	 * 是否已经安装
	 * @return
	 */
	boolean isInstalled();
	
	
	/**
	 * 卸载功能
	 */
	void uninstall();
	
	
	/**
	 * 执行功能行为
	 * @param actionName 行为名称
	 * @param args
	 * @return
	 */
	Object executeAction(String actionName, Object[] args) ;
	
}
