package net.ibizsys.model.engine.service.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IEntity;

public class WebClient extends WebClientBase<IPSModelEngine<?>, Object> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(WebClient.class);

	@Override
	public <T> T getProxyClient(Class<?> cls) {
		return null;
	}

	@Override
	protected <T> IWebClientRep<T> onGet(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
		try {
			if(StringUtils.hasLength(this.getServiceUrl())){
				strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
			}
			if (uriParams != null) {
				StringSubstitutor sub = new StringSubstitutor(uriParams);
				sub.setVariablePrefix("{");
				sub.setVariableSuffix("}");
				strUri = sub.replace(strUri);
			}

			if (queries != null) {
				String strQueryParam = getUrlParams(queries, false);
				if (StringUtils.hasLength(strQueryParam)) {
					if (strUri.indexOf("?") == -1) {
						strUri += "?";
					} else {
						strUri += "&";
					}
					strUri += strQueryParam;
				}
			}

			try (CloseableHttpClient httpClient = HttpClients.createDefault()) {

				HttpGet request = new HttpGet(strUri);
				if (headers != null) {
					for (String strHeader : headers.keySet()) {
						request.addHeader(strHeader, (String) headers.get(strHeader));
					}
				}
				Map<String, ?> globalHeaders = this.getHeaders();
				if (globalHeaders != null) {
					for (String strHeader : globalHeaders.keySet()) {
						request.addHeader(strHeader, (String) globalHeaders.get(strHeader));
					}
				}

				HttpResponse response = httpClient.execute(request);
				int statusCode = response.getStatusLine().getStatusCode();
				if (statusCode < 200 || statusCode >= 300) {
					String statusText = response.getStatusLine().getReasonPhrase();
					throw createWebClientResponseException(statusCode, statusText, response);
				} else {
					String responseBody = EntityUtils.toString(response.getEntity());
					MultiValueMap<String, String> headersMap = null;
					if (response.getAllHeaders() != null) {
						headersMap = new LinkedMultiValueMap<String, String>();
						for (Header header : response.getAllHeaders()) {
							headersMap.add(header.getName(), header.getValue());
						}
					}

					if (cls.isAssignableFrom(String.class)) {
						T t = (T) responseBody;
						return new WebClientRep<T>(t, headersMap);
					} else {
						T t = getMapper().readValue(responseBody, cls);
						return new WebClientRep<T>(t, headersMap);
					}
				}
			}

		} catch (Throwable ex) {

			PSModelEngineAddinException.rethrow(this, ex);

			throw new PSModelEngineAddinException(this, String.format("请求发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	protected <T> IWebClientRep<T> onPost(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object body, String strContentType, Class<T> cls, Object objTag) throws Throwable {
		try {
			if(StringUtils.hasLength(this.getServiceUrl())){
				strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
			}
			
			if (uriParams != null) {
				StringSubstitutor sub = new StringSubstitutor(uriParams);
				sub.setVariablePrefix("{");
				sub.setVariableSuffix("}");
				strUri = sub.replace(strUri);
			}

			if (queries != null) {
				String strQueryParam = getUrlParams(queries, false);
				if (StringUtils.hasLength(strQueryParam)) {
					if (strUri.indexOf("?") == -1) {
						strUri += "?";
					} else {
						strUri += "&";
					}
					strUri += strQueryParam;
				}
			}

			try (CloseableHttpClient httpClient = HttpClients.createDefault()) {

				HttpPost request = new HttpPost(strUri);
				if (headers != null) {
					for (String strHeader : headers.keySet()) {
						request.addHeader(strHeader, (String) headers.get(strHeader));
					}
				}
				Map<String, ?> globalHeaders = this.getHeaders();
				if (globalHeaders != null) {
					for (String strHeader : globalHeaders.keySet()) {
						request.addHeader(strHeader, (String) globalHeaders.get(strHeader));
					}
				}

				if (body != null) {
					request.setEntity(this.getHttpEntity(strContentType, body));
				}

				HttpResponse response = httpClient.execute(request);
				int statusCode = response.getStatusLine().getStatusCode();
				if (statusCode < 200 || statusCode >= 300) {
					String statusText = response.getStatusLine().getReasonPhrase();
					throw createWebClientResponseException(statusCode, statusText, response);
				} else {
					String responseBody = EntityUtils.toString(response.getEntity());
					MultiValueMap<String, String> headersMap = null;
					if (response.getAllHeaders() != null) {
						headersMap = new LinkedMultiValueMap<String, String>();
						for (Header header : response.getAllHeaders()) {
							headersMap.add(header.getName(), header.getValue());
						}
					}

					if (cls.isAssignableFrom(String.class)) {
						T t = (T) responseBody;
						return new WebClientRep<T>(t, headersMap);
					} else {
						T t = getMapper().readValue(responseBody, cls);
						return new WebClientRep<T>(t, headersMap);
					}
				}
			}

		} catch (Throwable ex) {

			PSModelEngineAddinException.rethrow(this, ex);

			throw new PSModelEngineAddinException(this, String.format("请求发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	protected <T> IWebClientRep<T> onPut(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object body, String strContentType, Class<T> cls, Object objTag) throws Throwable {
		try {
			if(StringUtils.hasLength(this.getServiceUrl())){
				strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
			}
			
			if (uriParams != null) {
				StringSubstitutor sub = new StringSubstitutor(uriParams);
				sub.setVariablePrefix("{");
				sub.setVariableSuffix("}");
				strUri = sub.replace(strUri);
			}

			if (queries != null) {
				String strQueryParam = getUrlParams(queries, false);
				if (StringUtils.hasLength(strQueryParam)) {
					if (strUri.indexOf("?") == -1) {
						strUri += "?";
					} else {
						strUri += "&";
					}
					strUri += strQueryParam;
				}
			}

			try (CloseableHttpClient httpClient = HttpClients.createDefault()) {

				HttpPut request = new HttpPut(strUri);
				if (headers != null) {
					for (String strHeader : headers.keySet()) {
						request.addHeader(strHeader, (String) headers.get(strHeader));
					}
				}
				Map<String, ?> globalHeaders = this.getHeaders();
				if (globalHeaders != null) {
					for (String strHeader : globalHeaders.keySet()) {
						request.addHeader(strHeader, (String) globalHeaders.get(strHeader));
					}
				}

				if (body != null) {
					request.setEntity(this.getHttpEntity(strContentType, body));
				}

				HttpResponse response = httpClient.execute(request);
				int statusCode = response.getStatusLine().getStatusCode();
				if (statusCode < 200 || statusCode >= 300) {
					String statusText = response.getStatusLine().getReasonPhrase();
					throw createWebClientResponseException(statusCode, statusText, response);
				} else {
					String responseBody = EntityUtils.toString(response.getEntity());
					MultiValueMap<String, String> headersMap = null;
					if (response.getAllHeaders() != null) {
						headersMap = new LinkedMultiValueMap<String, String>();
						for (Header header : response.getAllHeaders()) {
							headersMap.add(header.getName(), header.getValue());
						}
					}

					if (cls.isAssignableFrom(String.class)) {
						T t = (T) responseBody;
						return new WebClientRep<T>(t, headersMap);
					} else {
						T t = getMapper().readValue(responseBody, cls);
						return new WebClientRep<T>(t, headersMap);
					}
				}
			}

		} catch (Throwable ex) {

			PSModelEngineAddinException.rethrow(this, ex);

			throw new PSModelEngineAddinException(this, String.format("请求发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	protected <T> IWebClientRep<T> onPatch(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object body, String strContentType, Class<T> cls, Object objTag) throws Throwable {
		try {
			
			if(StringUtils.hasLength(this.getServiceUrl())){
				strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
			}
			
			if (uriParams != null) {
				StringSubstitutor sub = new StringSubstitutor(uriParams);
				sub.setVariablePrefix("{");
				sub.setVariableSuffix("}");
				strUri = sub.replace(strUri);
			}

			if (queries != null) {
				String strQueryParam = getUrlParams(queries, false);
				if (StringUtils.hasLength(strQueryParam)) {
					if (strUri.indexOf("?") == -1) {
						strUri += "?";
					} else {
						strUri += "&";
					}
					strUri += strQueryParam;
				}
			}

			try (CloseableHttpClient httpClient = HttpClients.createDefault()) {

				HttpPatch request = new HttpPatch(strUri);
				if (headers != null) {
					for (String strHeader : headers.keySet()) {
						request.addHeader(strHeader, (String) headers.get(strHeader));
					}
				}
				Map<String, ?> globalHeaders = this.getHeaders();
				if (globalHeaders != null) {
					for (String strHeader : globalHeaders.keySet()) {
						request.addHeader(strHeader, (String) globalHeaders.get(strHeader));
					}
				}

				if (body != null) {
					request.setEntity(this.getHttpEntity(strContentType, body));
				}

				HttpResponse response = httpClient.execute(request);
				int statusCode = response.getStatusLine().getStatusCode();
				if (statusCode < 200 || statusCode >= 300) {
					String statusText = response.getStatusLine().getReasonPhrase();
					throw createWebClientResponseException(statusCode, statusText, response);
				} else {
					String responseBody = EntityUtils.toString(response.getEntity());
					MultiValueMap<String, String> headersMap = null;
					if (response.getAllHeaders() != null) {
						headersMap = new LinkedMultiValueMap<String, String>();
						for (Header header : response.getAllHeaders()) {
							headersMap.add(header.getName(), header.getValue());
						}
					}

					if (cls.isAssignableFrom(String.class)) {
						T t = (T) responseBody;
						return new WebClientRep<T>(t, headersMap);
					} else {
						T t = getMapper().readValue(responseBody, cls);
						return new WebClientRep<T>(t, headersMap);
					}
				}
			}

		} catch (Throwable ex) {

			PSModelEngineAddinException.rethrow(this, ex);

			throw new PSModelEngineAddinException(this, String.format("请求发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	protected <T> IWebClientRep<T> onDelete(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
		try {
			
			if(StringUtils.hasLength(this.getServiceUrl())){
				strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
			}
			
			if (uriParams != null) {
				StringSubstitutor sub = new StringSubstitutor(uriParams);
				sub.setVariablePrefix("{");
				sub.setVariableSuffix("}");
				strUri = sub.replace(strUri);
			}

			if (queries != null) {
				String strQueryParam = getUrlParams(queries, false);
				if (StringUtils.hasLength(strQueryParam)) {
					if (strUri.indexOf("?") == -1) {
						strUri += "?";
					} else {
						strUri += "&";
					}
					strUri += strQueryParam;
				}
			}

			try (CloseableHttpClient httpClient = HttpClients.createDefault()) {

				HttpDelete request = new HttpDelete(strUri);
				if (headers != null) {
					for (String strHeader : headers.keySet()) {
						request.addHeader(strHeader, (String) headers.get(strHeader));
					}
				}
				Map<String, ?> globalHeaders = this.getHeaders();
				if (globalHeaders != null) {
					for (String strHeader : globalHeaders.keySet()) {
						request.addHeader(strHeader, (String) globalHeaders.get(strHeader));
					}
				}

				HttpResponse response = httpClient.execute(request);
				int statusCode = response.getStatusLine().getStatusCode();
				if (statusCode < 200 || statusCode >= 300) {
					String statusText = response.getStatusLine().getReasonPhrase();
					throw createWebClientResponseException(statusCode, statusText, response);
				} else {
					String responseBody = EntityUtils.toString(response.getEntity());
					MultiValueMap<String, String> headersMap = null;
					if (response.getAllHeaders() != null) {
						headersMap = new LinkedMultiValueMap<String, String>();
						for (Header header : response.getAllHeaders()) {
							headersMap.add(header.getName(), header.getValue());
						}
					}

					if (cls.isAssignableFrom(String.class)) {
						T t = (T) responseBody;
						return new WebClientRep<T>(t, headersMap);
					} else {
						T t = getMapper().readValue(responseBody, cls);
						return new WebClientRep<T>(t, headersMap);
					}
				}
			}

		} catch (Throwable ex) {

			PSModelEngineAddinException.rethrow(this, ex);

			throw new PSModelEngineAddinException(this, String.format("请求发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	protected IWebClientRep<?> onUpload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile, Object objTag) throws Throwable {
		try {
			
			if(StringUtils.hasLength(this.getServiceUrl())){
				strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
			}
			
			if (uriParams != null) {
				StringSubstitutor sub = new StringSubstitutor(uriParams);
				sub.setVariablePrefix("{");
				sub.setVariableSuffix("}");
				strUri = sub.replace(strUri);
			}

			if (queries != null) {
				String strQueryParam = getUrlParams(queries, false);
				if (StringUtils.hasLength(strQueryParam)) {
					if (strUri.indexOf("?") == -1) {
						strUri += "?";
					} else {
						strUri += "&";
					}
					strUri += strQueryParam;
				}
			}

			try (CloseableHttpClient httpClient = HttpClients.createDefault()) {

				HttpPost request = new HttpPost(strUri);
				if (headers != null) {
					for (String strHeader : headers.keySet()) {
						request.addHeader(strHeader, (String) headers.get(strHeader));
					}
				}
				Map<String, ?> globalHeaders = this.getHeaders();
				if (globalHeaders != null) {
					for (String strHeader : globalHeaders.keySet()) {
						request.addHeader(strHeader, (String) globalHeaders.get(strHeader));
					}
				}

				if (objFile instanceof java.io.File) {
					java.io.File file = (java.io.File) objFile;
					HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("file", file, ContentType.DEFAULT_BINARY, file.getName()).build();
					// 设置请求实体
					request.setEntity(entity);
				} else if (objFile instanceof java.io.InputStream) {
					java.io.InputStream is = (java.io.InputStream) objFile;
					HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("file", is).build();
					// 设置请求实体
					request.setEntity(entity);
					// fileEntity = new HttpEntity<>(new
					// InputStreamResource((java.io.InputStream) objFile));
				} else
					throw new Exception("无法识别的文件对象");

				HttpResponse response = httpClient.execute(request);
				int statusCode = response.getStatusLine().getStatusCode();
				if (statusCode < 200 || statusCode >= 300) {
					String statusText = response.getStatusLine().getReasonPhrase();
					throw createWebClientResponseException(statusCode, statusText, response);
				} else {
					String responseBody = EntityUtils.toString(response.getEntity());
					MultiValueMap<String, String> headersMap = null;
					if (response.getAllHeaders() != null) {
						headersMap = new LinkedMultiValueMap<String, String>();
						for (Header header : response.getAllHeaders()) {
							headersMap.add(header.getName(), header.getValue());
						}
					}

					return new WebClientRep<String>(responseBody, headersMap);
				}
			}

		} catch (Throwable ex) {

			PSModelEngineAddinException.rethrow(this, ex);

			throw new PSModelEngineAddinException(this, String.format("请求发生异常，%1$s", ex.getMessage()), ex);
		}

	}

	@Override
	protected IWebClientRep<?> onDownload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile, Object objTag) throws Throwable {

		try {
			
			if(StringUtils.hasLength(this.getServiceUrl())){
				strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
			}
			
			if (uriParams != null) {
				StringSubstitutor sub = new StringSubstitutor(uriParams);
				sub.setVariablePrefix("{");
				sub.setVariableSuffix("}");
				strUri = sub.replace(strUri);
			}

			if (queries != null) {
				String strQueryParam = getUrlParams(queries, false);
				if (StringUtils.hasLength(strQueryParam)) {
					if (strUri.indexOf("?") == -1) {
						strUri += "?";
					} else {
						strUri += "&";
					}
					strUri += strQueryParam;
				}
			}

			try (CloseableHttpClient httpClient = HttpClients.createDefault()) {

				HttpGet request = new HttpGet(strUri);
				if (headers != null) {
					for (String strHeader : headers.keySet()) {
						request.addHeader(strHeader, (String) headers.get(strHeader));
					}
				}
				Map<String, ?> globalHeaders = this.getHeaders();
				if (globalHeaders != null) {
					for (String strHeader : globalHeaders.keySet()) {
						request.addHeader(strHeader, (String) globalHeaders.get(strHeader));
					}
				}

				java.io.File file = null;
				java.io.OutputStream outputStream = null;
				java.io.Writer writer = null;
				if (objFile instanceof java.io.File) {
					file = (java.io.File) objFile;
				} else if (objFile instanceof java.io.OutputStream) {
					outputStream = (java.io.OutputStream) objFile;
				}
				// else
				// if(objFile instanceof java.io.Writer) {
				// writer = (java.io.Writer)objFile;
				// }
				else
					throw new Exception("无法识别的文件输出对象");

				HttpResponse response = httpClient.execute(request);
				int statusCode = response.getStatusLine().getStatusCode();
				if (statusCode < 200 || statusCode >= 300) {
					String statusText = response.getStatusLine().getReasonPhrase();
					throw createWebClientResponseException(statusCode, statusText, response);
				} else {

					HttpEntity entity = response.getEntity();

					if (entity != null) {
						// 将响应实体保存到文件
						if (outputStream == null) {
							try (InputStream inStream = entity.getContent()) {
								FileUtils.copyInputStreamToFile(inStream, file);
							}
						} else {
							try (InputStream inStream = entity.getContent()) {
								IOUtils.copyLarge(inStream, outputStream);
							}
						}
					}

					// 消耗响应实体
					EntityUtils.consume(entity);

					MultiValueMap<String, String> headersMap = null;
					if (response.getAllHeaders() != null) {
						headersMap = new LinkedMultiValueMap<String, String>();
						for (Header header : response.getAllHeaders()) {
							headersMap.add(header.getName(), header.getValue());
						}
					}

					String strFileName = null;
					List<String> list = headersMap.get("Content-Disposition");
					if (!ObjectUtils.isEmpty(list)) {
						strFileName = list.get(0);
						if (strFileName.indexOf("attachment;filename=") == 0) {
							strFileName = strFileName.substring("attachment;filename=".length());
						}
					}

					return new WebClientRep<String>(strFileName, headersMap);
				}
			}

		} catch (Throwable ex) {

			PSModelEngineAddinException.rethrow(this, ex);

			throw new PSModelEngineAddinException(this, String.format("请求发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	protected WebClientResponseException createWebClientResponseException(int statusCode, String statusText, HttpResponse response) {
		String responseBody = null;
		if (response != null) {
			try {
				responseBody = EntityUtils.toString(response.getEntity());
			} catch (Exception ex) {
				log.error(ex);
			}
			if (StringUtils.hasLength(responseBody)) {
				if (responseBody.indexOf("{") == 0) {
					try {
						JsonNode jsonNode = getMapper().readTree(responseBody);
						if (jsonNode instanceof ObjectNode) {
							JsonNode messageNode = ((ObjectNode) jsonNode).get("message");
							if (messageNode != null && !messageNode.isNull()) {
								statusText = messageNode.asText();
							}
						}
					} catch (Exception ex) {
						log.error(ex);
					}
				}
			}
		}
		if(!StringUtils.hasLength(statusText)) {
			
		}
		return new WebClientResponseException(this, statusCode, statusText, responseBody);
	}

	protected HttpEntity getHttpEntity(String strContentType, Object body) throws Exception {
		if (ObjectUtils.isEmpty(strContentType) || strContentType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
			String strBody = null;
			if (body instanceof String) {
				strBody = (String) body;
			} else {
				strBody = getOutMapper().writeValueAsString(body);
			}
			return new StringEntity(strBody, ContentType.create(ContentType.APPLICATION_JSON.getMimeType(), "UTF-8"));
		} else if (strContentType.equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
			return new UrlEncodedFormEntity(getFormData(body), "UTF-8");
		} else if ((strContentType.equals(ContentType.TEXT_XML.getMimeType())) || (strContentType.equals(ContentType.TEXT_HTML.getMimeType())) || (strContentType.equals(ContentType.TEXT_PLAIN.getMimeType()))) {
			String content = "";
			if (body != null) {
				content = body.toString();
			}
			return new StringEntity(content, ContentType.create(strContentType, "UTF-8"));
		} else {
			throw new Exception(String.format("未支持的内容类型[%1$s]", strContentType));
		}
	}

	protected List<NameValuePair> getFormData(Object body) throws Exception {
		Map<String, ?> map = null;
		if (body instanceof Map) {
			map = (Map<String, ?>) body;
		} else if (body instanceof IEntity) {
			map = ((IEntity) body).any();
		} else
			throw new Exception(String.format("无法识别的内容对象"));

		List<NameValuePair> formParams = new ArrayList<NameValuePair>();

		MultiValueMap<String, String> parts = new LinkedMultiValueMap<>();
		if (map != null) {
			for (java.util.Map.Entry<String, ?> entry : map.entrySet()) {
				Object objValue = entry.getValue();
				if (objValue == null) {
					formParams.add(new BasicNameValuePair(entry.getKey(), ""));
				} else {
					formParams.add(new BasicNameValuePair(entry.getKey(), objValue.toString()));
				}
			}
		}

		return formParams;
	}
}
