package net.ibizsys.model.engine.service;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.http.entity.ContentType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.model.PSModelEnums.APIAuthMode;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.plugin.IPSModelEngineScript;
import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.engine.service.client.IWebClientRep;
import net.ibizsys.model.engine.util.JsonUtils;
import net.ibizsys.model.service.IPSSubSysServiceAPI;



public abstract class PSSubSysServiceAPIEngineBase<M extends IPSSubSysServiceAPI> extends PSSubSysServiceAPIEngineBaseBase<M> implements IPSSubSysServiceAPIEngine<M>{

	
	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSSubSysServiceAPIEngineBase.class);
	
	private Map<String, Object> globalHeaderMap = null;

	private Map<String, Object> defaultHeaderMap = null;

	private IWebClient<?, ?> iWebClient = null;
	
	private long tokenTimeout = 0;
	
	private String serviceType = null;
	
	private String serviceParam3 = null;

	private String serviceParam4 = null;
	
	private String authParam3 = null;

	private String authParam4 = null;
	
	private IPSModelEngineScript<?> authPSModelEngineScript = null;
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, String id, M iPSModelObject) throws Exception {
//		if (!(iPSModelObject instanceof IPSSubSysServiceAPI)) {
//			throw new Exception(String.format("模型类型不正确"));
//		}
//		IPSSubSysServiceAPI iPSSubSysServiceAPI = (IPSSubSysServiceAPI)iPSModelObject;
		this.setConfigFolder("subsysserviceapi." + PSModelUtils.calcUniqueTag(iPSModelObject.getPSSystemModule(), iPSModelObject.getCodeName()));
		super.init(iPSModelEngineHolder, id, iPSModelObject);
	}
	
	@Override
	protected void onPrepareSetting() throws Exception {
		// 计算服务路径
		this.setServiceType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".servicetype", this.getPSModelObject().getServiceType()));
		this.setServiceParam3(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".serviceparam3", this.getPSModelObject().getServiceParam3()));
		this.setServiceParam4(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".serviceparam4", this.getPSModelObject().getServiceParam4()));
		this.setAuthParam3(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".authparam3", this.getPSModelObject().getAuthParam3()));
		this.setAuthParam4(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".authparam4", this.getPSModelObject().getAuthParam4()));

		super.onPrepareSetting();
	}
	
	@Override
	protected void onInit() throws Exception {
		this.setHeaders(null);
		
		
		super.onInit();
		
		

//		// 准备实体服务接口
//		java.util.List<IPSSubSysServiceAPIDE> psSubSysServiceAPIDEs = this.getPSSubSysServiceAPI().getAllPSSubSysServiceAPIDEs();
//		if (psSubSysServiceAPIDEs != null) {
//			for (IPSSubSysServiceAPIDE iPSSubSysServiceAPIDE : psSubSysServiceAPIDEs) {
//				this.registerPSSubSysServiceAPIDE(iPSSubSysServiceAPIDE);
//			}
//		}
//
//		if (getParamSubSysServiceAPIScriptLogicRuntime() == null) {
//			ISubSysServiceAPIScriptLogicRuntime iSubSysServiceAPIScriptLogicRuntime = this.getSystemRuntime().createSubSysServiceAPIScriptLogicRuntime(ISubSysServiceAPIScriptLogicRuntime.LOGICMODE_METHODPARAM);
//			iSubSysServiceAPIScriptLogicRuntime.init(this.getSystemRuntime(), this, "return {uri:'',param:{},header:{},query:{},body:null};", ISubSysServiceAPIScriptLogicRuntime.LOGICMODE_METHODPARAM);
//			setParamSubSysServiceAPIScriptLogicRuntime(iSubSysServiceAPIScriptLogicRuntime);
//		}

//		if (this.getMethodScriptLogicRuntime() == null) {
//			this.prepareMethodScriptLogicRuntime();
//		}

		this.prepareAuthUtil();

//		if (this.getObjectStorageServiceAdapter() == null) {
//			prepareObjectStorageServiceAdapter();
//		}
	}
	
//	@Override
//	public IPSSubSysServiceAPI getPSModelObject() {
//		return (IPSSubSysServiceAPI)super.getPSModelObject();
//	}
//	
//	@Override
//	public IPSSubSysServiceAPI getPSSubSysServiceAPI() {
//		return getPSModelObject();
//	}
//	
	
	
	
	
	protected String getMethodScriptCode() {
		return this.getPSModelObject().getMethodScriptCode();
	}

	protected String getAuthScriptCode() {
		return this.getPSModelObject().getAuthScriptCode();
	}

	@Override
	public void setHeaders(Map<String, ?> headers) {

		if (this.defaultHeaderMap == null) {
			Map<String, Object> defaultMap = new ConcurrentHashMap<String, Object>();
			if (this.getPSModelObject() != null) {
				ObjectNode objectNode = this.getPSModelObject().getHeaderParams();
				if (objectNode != null) {
					java.util.Iterator<String> fields = objectNode.fieldNames();
					if (fields != null) {
						while (fields.hasNext()) {
							String strName = fields.next();
							defaultMap.put(strName, objectNode.get(strName).textValue());
						}
					}
				}
			}
			this.defaultHeaderMap = Collections.unmodifiableMap(defaultMap);
		}

		Map<String, Object> map = new ConcurrentHashMap<String, Object>();
		map.putAll(this.defaultHeaderMap);

		if (headers != null) {
			map.putAll(headers);
		}

		if (map == null || map.size() == 0) {
			this.globalHeaderMap = null;
		} else {
			this.globalHeaderMap = Collections.unmodifiableMap(map);
		}
	}

	@Override
	public Map<String, ?> getHeaders(boolean bAuthMode) {
		if (bAuthMode) {
			return this.defaultHeaderMap;
		}
		return this.globalHeaderMap;
	}

	@Override
	public Map<String, ?> getHeaders() {
		return getHeaders(false);
	}

	@Override
	public IWebClient<?, ?> getWebClient() {
		try {
			return getWebClient(false);
		}
		catch (Exception ex) {
			throw new PSModelEngineException(this, String.format("WebClient对象无效，%1$s", ex.getMessage()), ex);
		}
	}

	protected IWebClient<?, ?> getWebClient(boolean bTryMode) throws Exception{
		if (this.iWebClient != null || bTryMode) {
			return this.iWebClient;
		}
		this.iWebClient = createWebClient();
		return this.iWebClient;
	}

	protected IWebClient<?, ?> createWebClient() throws Exception{
		return this.getPSModelEngineHolder().getPSModelEngineAddin(this, null, IWebClient.class);
	}
	
	@Override
	public long getTokenTimeout() {
		return this.tokenTimeout;
	}

	@Override
	public void setTokenTimeout(long tokenTimeout) {
		this.tokenTimeout = tokenTimeout;
	}
	
	@Override
	public void tokenExpireIn(int nSeconds) {
		if (nSeconds >= 0) {
			this.setTokenTimeout(System.currentTimeMillis() + nSeconds * 1000);
		}
	}
	
	@Override
	public String getServiceType() {
		return this.serviceType;
	}

	protected void setServiceType(String serviceType) {
		this.serviceType = serviceType;
	}
	
	@Override
	public String getServiceParam3() {
		return this.serviceParam3;
	}

	protected void setServiceParam3(String serviceParam3) {
		this.serviceParam3 = serviceParam3;
	}

	@Override
	public String getServiceParam4() {
		return this.serviceParam4;
	}

	protected void setServiceParam4(String serviceParam4) {
		this.serviceParam4 = serviceParam4;
	}
	
	@Override
	public String getAuthParam3() {
		return this.authParam3;
	}

	protected void setAuthParam3(String authParam3) {
		this.authParam3 = authParam3;
	}

	@Override
	public String getAuthParam4() {
		return this.authParam4;
	}

	protected void setAuthParam4(String authParam4) {
		this.authParam4 = authParam4;
	}
	

	
	protected void prepareAuthUtil() throws Exception {
		if (StringUtils.hasLength(this.getAuthMode()) && !APIAuthMode.NONE.value.equals(this.getAuthMode())) {
			
			if (this.getAuthPSModelEngineScript() == null) {
				this.prepareAuthPSModelEngineScript();
			}

			// 启动计时器
			runAuthTimer(true);
		}
	}
	
	protected IPSModelEngineScript<?> getAuthPSModelEngineScript() {
		return this.authPSModelEngineScript;
	}
	
	protected void setAuthPSModelEngineScript(IPSModelEngineScript<?> authPSModelEngineScript) {
		this.authPSModelEngineScript = authPSModelEngineScript;
	}

	
	protected void prepareAuthPSModelEngineScript() throws Exception {
		if (!StringUtils.hasLength(this.getAuthScriptCode())) {
			return;
		}
		
		this.setAuthPSModelEngineScript(this.getPSModelEngineHolder().getPSModelEngineAddin(this, this.getAuthScriptCode(), IPSModelEngineScript.class));

	}
	
	@Override
	public void requestTokenIf(boolean bImmediately) {
		if (this.getTokenTimeout() - System.currentTimeMillis() >= 60000) {
			return;
		}
		this.requestToken(bImmediately);
	}

	@Override
	public void requestToken() {
		this.requestToken(false);
	}

	@Override
	public void requestToken(boolean bImmediately) {
		if (bImmediately) {
			try {
				onRequestToken();
			}
			catch (Throwable ex) {
				log.error(String.format("外部服务接口[%1$s]认证发生异常，%2$s", getName(), ex.getMessage()), ex);
				// 下一个时间周期继续认证
				this.setTokenTimeout(0);
				throw new PSModelEngineException(this, String.format("认证发生异常，%1$s", ex.getMessage()), ex);
			}
		} else {
			this.setTokenTimeout(0);
		}
	}

	protected void onRequestToken() throws Throwable{
		
		long nLastTokenTimeout = this.getTokenTimeout();

		doRequestTokenReal();
		// this.setAuthFirst(false);
		if (this.getTokenTimeout() == nLastTokenTimeout) {
			this.setTokenTimeout(System.currentTimeMillis() + this.getDefaultTokenTimeout());
		}
	}

	protected void doRequestTokenReal() throws Throwable {
		if (this.getAuthPSModelEngineScript() == null) {
			// 尝试默认
			if (APIAuthMode.CLIENT_CREDENTIALS.value.equalsIgnoreCase(this.getAuthMode())) {
				doRequestToken_ClientCredentials();
				return;
			}

			throw new Exception(String.format("未定义认证处理逻辑"));

		}
		this.getAuthPSModelEngineScript().call();
	}

	protected void doRequestToken_ClientCredentials() throws Throwable {
		String credentials = String.format("%1$s:%2$s", this.getClientId(), this.getClientSecret());
		byte[] credentialsBytes = credentials.getBytes(StandardCharsets.UTF_8);
		String encodedCredentials = Base64.getEncoder().encodeToString(credentialsBytes);
		String authorization = "Basic " + encodedCredentials;

		Map<String, Object> body = new LinkedHashMap<String, Object>();
		body.put("grant_type", "client_credentials");
		
		Map<String, Object> headers = new LinkedHashMap<String, Object>();
		headers.put("Authorization", authorization);
		
		IWebClientRep<String> rep =	this.getPSModelEngineHolder().getPSSystemEngine().getDefaultWebClient().post(this.getAccessTokenUrl(), null, headers, null, body, ContentType.APPLICATION_FORM_URLENCODED.getMimeType(), String.class, null);
		
		Map<String, Object> map = JsonUtils.asMap(rep.getBody());
		Object access_token = map.get("access_token");
		Object token_type = map.get("token_type");
		Object expires_in = map.get("expires_in");
		
		if(ObjectUtils.isEmpty(access_token)) {
			throw new Exception("认知结果未包含凭证信息");
		}
		
		if(ObjectUtils.isEmpty(token_type)) {
			token_type = "bearer";
		}
		
		headers.clear();
		headers.put("Authorization", String.format("%1$s %2$s", StringUtils.capitalize(token_type.toString()), access_token));
		this.setHeaders(headers);
		
		if(expires_in instanceof Integer) {
			this.tokenExpireIn((int)expires_in);
		}
		
	}

	protected void runAuthTimer() {
		runAuthTimer(false);
	}

	protected void runAuthTimer(boolean bTimerOnly) {
		if (!bTimerOnly) {
			try {
				onAuthTimer();
			} catch (Throwable ex) {
				log.error(String.format("外部服务接口[%1$s]认证定时器处理发生异常，%2$s", getName(), ex.getMessage()), ex);
				this.getPSModelEngineHolder().getPSSystemLogger().error(this.getLogCat(), String.format("外部服务接口[%1$s]认证定时器处理发生异常，%2$s", getName(), ex.getMessage()), ex);
			}
		}

		this.getPSModelEngineHolder().getPSSystemEngine().threadRun(new Runnable() {
			@Override
			public void run() {
				runAuthTimer();
			}
		}, System.currentTimeMillis() + 10000, "AuthTimer_" + this.getPSModelObject().getId());
	}

	protected void onAuthTimer() throws Throwable{
		if (this.getTokenTimeout() - System.currentTimeMillis() >= getRenewTokenInterval()) {
			return;
		}

		// 执行认证
		//onRequestToken();
		requestToken(true);
	}

	protected long getRenewTokenInterval() {
		return 60000l;
	}
}
