package net.ibizsys.model.engine.service;

import java.util.Map;

import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.service.IPSSubSysServiceAPI;

public interface IPSSubSysServiceAPIEngine<M extends IPSSubSysServiceAPI> extends IPSSubSysServiceAPIEngineBase<M>{

//	/**
//	 * 获取外部系统接口模型对象
//	 * @return
//	 */
//	IPSSubSysServiceAPI getPSSubSysServiceAPI();
	
	
	
	/**
	 * 获取全局请求头内容
	 * @return
	 */
	Map<String, ?> getHeaders();
	
	
	/**
	 * 获取全局请求头内容
	 * @param bAuthMode 是否为认证请求
	 * @return
	 */
	Map<String, ?> getHeaders(boolean bAuthMode);
	
	/**
	 * 设置全局请求头内容
	 * @param headers
	 */
	void setHeaders(Map<String, ?> headers);
	
	
	/**
	 * 请求认证（异步）
	 */
	void requestToken();
	
	/**
	 * 请求认证
	 * @param bImmediately 立即请求
	 */
	void requestToken(boolean bImmediately);
	
	
	/**
	 * 请求认证（如果当前未认证）
	 * @param bImmediately 立即请求
	 */
	void requestTokenIf(boolean bImmediately);
	
	
	
	
	/**
	 * 获取默认的Web客户端对象
	 * @return
	 */
	IWebClient<?, ?> getWebClient();
	
	
	/**
	 * 认证参数3
	 * @return
	 */
	java.lang.String getAuthParam3();
	
	
	/**
	 * 认证参数4
	 * @return
	 */
	java.lang.String getAuthParam4();
	
	/**
	 * 获取服务类型
	 * @return
	 */
	String getServiceType();
	
	
	
	/**
	 * 获取服务参数3
	 * @return
	 */
	String getServiceParam3();
	
	
	/**
	 * 获取服务参数4
	 * @return
	 */
	String getServiceParam4();
	
	
	/**
	 * 获取Token过期时长（毫秒）
	 * @return
	 */
	long getTokenTimeout();

	/**
	 * 设置Token过期时长（毫秒）
	 * @param tokenTimeout
	 */
	void setTokenTimeout(long tokenTimeout);
	
	/**
	 * 设置Token在指定秒数后过期
	 * @param seconds 过期秒数
	 */
	void tokenExpireIn(int seconds);
}
