package net.ibizsys.model.engine.security;

public class SecurityContextHolder {

	private static ThreadLocal<ISecurityContext> securityContextThreadLocal = new ThreadLocal<ISecurityContext>();
	
	public static ISecurityContext getCurrent() {
		return securityContextThreadLocal.get();
	}
	
	public static ISecurityContext getCurrentMust() {
		ISecurityContext iNavigateContext = securityContextThreadLocal.get();
		if(iNavigateContext == null) {
			throw new RuntimeException("当前安全上下文无效");
		}
		return iNavigateContext;
	}
	
	public static void setCurrent(ISecurityContext iNavigateContext) {
		securityContextThreadLocal.set(iNavigateContext);
	}
}
