package net.ibizsys.model.engine.security;

import java.util.HashMap;
import java.util.Map;

public class SecurityContext implements ISecurityContext {
	
	private Map<String, Object> sessionParams = new HashMap<String, Object>();
	
	@Override
	public Object getSessionValue(String name) {
		return this.sessionParams.get(name);
	}

	@Override
	public Map<String, Object> getSession() {
		Map<String, Object> map = new HashMap<String, Object>();
		map.putAll(sessionParams);
		return map;
	}

	@Override
	public void setSessionValue(String name, Object value) {
		this.sessionParams.put(name, value);
	}

}
