package net.ibizsys.model.engine.security;

import java.util.Map;

/**
 * 安全上下文对象接口
 * @author lionlau
 *
 */
public interface ISecurityContext {

	/**
	 * 获取会话值
	 * @param name
	 * @return
	 */
	Object getSessionValue(String name);
	
	
	/**
	 * 获取会话集合
	 * @return
	 */
	Map<String, Object> getSession();
	
	
	
	/**
	 * 设置会话值
	 * @param name
	 * @param value
	 */
	void setSessionValue(String name, Object value);
}
