package net.ibizsys.model.engine.res;

import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.res.IPSSysTranslator;

public abstract class PSSysTranslatorEngineBase<M extends IPSSysTranslator> extends PSModelEngineBase<M> implements IPSSysTranslatorEngine<M> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSSysTranslatorEngineBase.class);
	
	
//	@Override
//	public IPSSysTranslator getPSSysTranslator() {
//		return getPSModelObject();
//	}
//	
//	@Override
//	public IPSSysTranslator getPSModelObject() {
//		return (IPSSysTranslator)super.getPSModelObject();
//	}

	@Override
	public Object translate(Object value, boolean inMode) {
		return this.translate(value, inMode, null);
	}

	@Override
	public Object translate(Object value, boolean inMode, Object data) {
		return this.executeAction("转化处理", new IAction<Object>() {
			@Override
			public Object execute(Object[] args) throws Throwable {
				return onTranslate(value, inMode, data);
			}
		});
	}
	
	protected Object onTranslate(Object value, boolean inMode, Object data) throws Throwable{
		throw new Exception("没有实现");
	}
	
	
}
