package net.ibizsys.model.engine.res;

import org.springframework.util.StringUtils;

import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.res.IPSSysSFPlugin;

public abstract class PSSysSFPluginEngineBase<X extends IPSSysSFPlugin> extends PSModelEngineBase<X> implements IPSSysSFPluginEngine<X> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSSysSFPluginEngineBase.class);
	private boolean runtimePlugin = false;
	private String rtObjectName = null;
	
	private String rtObjectCode = null;
	private Object runtimeObject = null;
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineContext, String id, X iPSModelObject) throws Exception {
		this.setConfigFolder("syssfplugin." + PSModelUtils.calcUniqueTag(iPSModelObject.getPSSystemModule(), iPSModelObject.getPluginCode()));
		super.init(iPSModelEngineContext, id, iPSModelObject);
	}
	


	@Override
	protected void onPrepareSetting() throws Exception {
		this.setRuntimePlugin(this.getPSModelObject().isRuntimeObject());
		this.setRTObjectName(this.getPSModelObject().getRTObjectName());
		super.onPrepareSetting();
	}
	
	@Override
	public boolean isRuntimePlugin() {
		return this.runtimePlugin;
	}

	protected void setRuntimePlugin(boolean runtimePlugin) {
		this.runtimePlugin = runtimePlugin;
	}
	
	/**
	 * 获取运行时对象名称
	 * 
	 * @return
	 */
	@Override
	public String getRTObjectName() {
		return this.rtObjectName;
	}
	
	/**
	 * 设置运行时对象名称
	 * @param rTObjectName
	 */
	protected void setRTObjectName(String rtObjectName) {
		this.rtObjectName = rtObjectName;
	}
	
	
	protected abstract Class<?> getRTObjectClass();
	

	@Override
	public <T> T getRuntimeObject(Class<T> cls, boolean bNewInstance) throws Exception {
		if (!isRuntimePlugin()) {
			throw new PSModelEngineException(this, String.format("系统后台插件[%1$s]不提供运行时组件", this.getName()));
		}

		Class<?> rtObjectClass = getRTObjectClass();
		
		if (!cls.isAssignableFrom(rtObjectClass)) {
			throw new PSModelEngineException(this, String.format("系统后台插件[%1$s]不支持指定类型[%2$s]", this.getName(), cls.getCanonicalName()));
		}

		if (bNewInstance) {
			Object objItem = rtObjectClass.newInstance();
			
			//this.autowareObject(objItem);
			return (T) objItem;
		}

		if (this.runtimeObject == null) {
			Object objItem = rtObjectClass.newInstance();
//			if(objItem instanceof IPluginRuntimeInitable) {
//				((IPluginRuntimeInitable)objItem).init(this.getSystemRuntimeContext(), this.getPSSysSFPlugin());
//			}
//			this.autowareObject(objItem);
			this.runtimeObject = objItem;
		}

		return (T) this.runtimeObject;
	}
	
	@Override
	public Object getRuntimeObject(boolean bNewInstance) throws Exception {
		if (!isRuntimePlugin()) {
			throw new PSModelEngineException(this, String.format("系统后台插件[%1$s]不提供运行时组件", this.getName()));
		}

		Class<?> rtObjectClass = getRTObjectClass();

		if (bNewInstance) {
			Object objItem = rtObjectClass.newInstance();
//			if(objItem instanceof IPluginRuntimeInitable) {
//				((IPluginRuntimeInitable)objItem).init(this.getSystemRuntimeContext(), this.getPSSysSFPlugin());
//			}
//			this.autowareObject(objItem);
			return objItem;
		}

		if (this.runtimeObject == null) {
			Object objItem = rtObjectClass.newInstance();
//			if(objItem instanceof IPluginRuntimeInitable) {
//				((IPluginRuntimeInitable)objItem).init(this.getSystemRuntimeContext(), this.getPSSysSFPlugin());
//			}
//			this.autowareObject(objItem);
			this.runtimeObject = objItem;
		}

		return this.runtimeObject;
	}
	
//	protected void autowareObject(Object object) throws Exception {
//		this.getSystemRuntime().autowareObject(object);
//	}
	
	public String getRTObjectCode() {
		if(StringUtils.hasLength(this.rtObjectCode)) {
			return this.rtObjectCode;
		}
		
//		String strHotCode = getHotCode(this.getSystemRuntime().getDeploySystemId(), this.getPSSysSFPlugin().getId());
//		if(StringUtils.hasLength(strHotCode)) {
//			return strHotCode;
//		}
		
		return this.getPSModelObject().getTemplCode();
	}
	
	protected void setRTObjectCode(String rtObjectCode) {
		this.rtObjectCode = rtObjectCode;
	}
}
