package net.ibizsys.model.engine.res;

import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.res.IPSSysSFPlugin;

public interface IPSSysSFPluginEngine<M extends IPSSysSFPlugin> extends IPSModelEngine<M>{

	
	/**
	 * 获取运行时对象
	 * @param cls
	 * @param bNewInstance
	 * @return
	 * @throws Exception
	 */
	<T> T getRuntimeObject(Class<T> cls, boolean bNewInstance)throws Exception;
	
	
	
	
	/**
	 * 获取运行时对象
	 * @param bNewInstance
	 * @return
	 * @throws Exception
	 */
	Object getRuntimeObject(boolean bNewInstance)throws Exception;
	
	
	
	/**
	 * 是否为运行时组件对象
	 * @return
	 */
	boolean isRuntimePlugin();
	
	
	
	
	/**
	 * 获取运行对象名称
	 * @return
	 */
	String getRTObjectName();
	
	
	
//	/**
//	 * 是否为Groovy运行时插件
//	 * @return
//	 */
//	boolean isGroovyRTObject();
	
	
	
	/**
	 * 获取运行时对象代码
	 * @return
	 */
	String getRTObjectCode();

}
