package net.ibizsys.model.engine.plugin;

import org.springframework.util.Assert;

import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.IPSSystemLogger;
import net.ibizsys.model.engine.IPSSystemUtil;

public abstract class PSModelEngineAddinBase<E extends IPSModelEngine<?>, M> implements IPSModelEngineAddin<E, M>{

	private IPSModelEngineHolder iPSModelEngineHolder = null;
	private E iPSModelEngine  = null;
	private String configFolder = null;
	private M data = null;
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, E iPSModelEngine, M data) throws Exception {
		Assert.notNull(iPSModelEngineHolder, "模型引擎上下文对象无效");
		Assert.notNull(iPSModelEngine, "模型对象无效");
		this.iPSModelEngineHolder = iPSModelEngineHolder;
		this.iPSModelEngine = iPSModelEngine;
		this.data = data;
		this.onPrepareSetting();
		this.onInit();		
	}
	
	protected void onInit() throws Exception {
		
	}
	
	/**
	 * 准备默认设置
	 * @throws Exception
	 */
	protected void prepareSetting() throws Exception{
		this.onPrepareSetting();
	}
	
	protected void onPrepareSetting() throws Exception{
		
	}
//	
//	@Override
//	public abstract String getId() {
//		return this.id;
//	}
	
	@Override
	public abstract String getName();
	
	
	@Override
	public String getFullName() {
		return getName();
	}

	@Override
	public E getPSModelEngine() {
		return this.iPSModelEngine;
	}
	
	protected IPSModelEngineHolder getPSModelEngineHolder() {
		return this.iPSModelEngineHolder;
	}

	protected void setConfigFolder(String configFolder) {
		this.configFolder = configFolder;
	}
	
	
	/**
	 * 获取模型的运行时配置目录
	 * @return
	 */
	protected String getConfigFolder() {
		return this.configFolder;
	}
	
	protected M getAddinData() {
		return this.data;
	}
	
	protected IPSSystemLogger getLogger(){
		return this.getPSModelEngineHolder().getPSSystemLogger();
	}
	
	protected IPSSystemUtil getUtil(){
		return this.getPSModelEngineHolder().getPSSystemUtil();
	}
	
	protected String getLogCat() {
		return getFullName();
	}
}
