package net.ibizsys.model.engine.eai;

import java.util.Arrays;
import java.util.List;

import org.springframework.util.StringUtils;

import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.service.PSSubSysServiceAPIEngineBaseBase;
import net.ibizsys.model.res.IPSSysDataSyncAgent;


public abstract class PSSysDataSyncAgentEngineBase<M extends IPSSysDataSyncAgent> extends PSSubSysServiceAPIEngineBaseBase<M> implements IPSSysDataSyncAgentEngine<M> {

	private List<String> topics = null;
	
	private String defaultTopic = null;
	
	private String groupId = null;
	
	private boolean transacted = false;
	
	private String agentType = null;
	
	private boolean groupIdDefined = false;
	
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineContext, String id, M iPSModelObject) throws Exception {
		this.setConfigFolder("syseaiagent." + PSModelUtils.calcUniqueTag(iPSModelObject.getPSSystemModule(), iPSModelObject.getCodeName()));
		super.init(iPSModelEngineContext, id, iPSModelObject);
	}
	
	
	@Override
	protected void onInit() throws Exception {
		
		
		this.setAgentType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".agenttype", this.getPSSysDataSyncAgent().getAgentType()));
		
		String strTopic = this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".topic", this.getPSSysDataSyncAgent().getTopic());
		if(!StringUtils.hasLength(strTopic)
				&& StringUtils.hasLength(this.getPSSysDataSyncAgent().getCodeName())) {
			strTopic = this.getPSSysDataSyncAgent().getCodeName().toLowerCase();
		}
		if(StringUtils.hasLength(strTopic)) {
			String[] topics = strTopic.split("[;]");
			this.setTopics(Arrays.asList(topics));
			this.setDefaultTopic(topics[0]);
		}
		
//		this.setTransacted(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".transacted", DataTypeUtils.getBooleanValue(this.getAgentParam(PARAM_TRANSACTED, null), false)));
		
		this.setGroupId(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".groupid", this.getPSSysDataSyncAgent().getGroupId()));
//		if(!StringUtils.hasLength(this.getGroupId())) {
//			this.setGroupId(this.getSystemRuntime().getDeploySystemId());
//		}
//		else {
//			setGroupIdDefined(true);
//		}
		super.onInit();
	}
	
	public IPSSysDataSyncAgent getPSSysDataSyncAgent() {
		return getPSModelObject();
	}
	
//	@Override
//	public IPSSysDataSyncAgent getPSModelObject() {
//		return (IPSSysDataSyncAgent)super.getPSModelObject();
//	}
//	
	
	
	@Override
	public void send(Object[] data) {
		throw new PSModelEngineException(this, "没有实现");
	}


	@Override
	public boolean isRawDataMode() {
		// TODO Auto-generated method stub
		return false;
	}


	//@Override
	public List<String> getTopics() {
		return this.topics;
	}

	protected void setTopics(List<String> topics) {
		this.topics = topics;
	}
	
	//@Override
	public String getDefaultTopic() {
		return this.defaultTopic;
	}

	protected void setDefaultTopic(String defaultTopic) {
		this.defaultTopic = defaultTopic;
	}


	
	//@Override
	public String getGroupId() {
		return this.groupId;
	}
	
	protected void setGroupId(String groupId) {
		this.groupId = groupId;
	}
	
	//@Override
	public boolean isGroupIdDefined() {
		return this.groupIdDefined;
	}
	
	protected void setGroupIdDefined(boolean groupIdDefined) {
		this.groupIdDefined = groupIdDefined;
	}
	
	
	public boolean isTransacted() {
		return this.transacted;
	}
	
	public void setTransacted(boolean transacted) {
		this.transacted = transacted;
	}
	

	protected void setAgentType(String agentType) {
		this.agentType = agentType;
	}
	
	//@Override
	public String getAgentType() {
		return this.agentType;
	}
	
	
	
}
