package net.ibizsys.model.engine.dataentity.service;

import net.ibizsys.model.dataentity.service.IPSDEMethodReturn;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.plugin.PSModelEngineAddin2Base;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;

public abstract class PSDEMethodReturnAddinBase<E extends IPSModelEngine<?>, M extends IPSDEMethodReturn> extends PSModelEngineAddin2Base<E, M> implements IPSDEMethodReturnAddin<E, M>{

	@Override
	public Object convert(Object value)  {
		try {
			return this.onConvert(value);
		}
		catch (Throwable ex) {
			throw new PSModelEngineAddinException(this, String.format("返回值转换发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	protected Object onConvert(Object value) throws Throwable {
		return value;
	}
}
