package net.ibizsys.model.engine.dataentity.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.ibizsys.model.PSModelEnums.DEMethodDTOFieldType;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.engine.util.IEntity;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.model.util.DataTypes;

public abstract class PSDEMethodDTOEngineBase<T extends IPSDEMethodDTO>  extends PSModelEngineBase<T> implements IPSDEMethodDTOEngine<T>{

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSDEMethodDTOEngineBase.class);
	
	private Map<String, IPSDEMethodDTOField> psDEMethodDTOFieldMap = new HashMap<String, IPSDEMethodDTOField>();
	private Map<String, IPSDEMethodDTOField> psDEMethodDTOFieldMap2 = null;
	
	@Override
	protected void onInit() throws Exception {
		
		List<IPSDEMethodDTOField> psDEMethodDTOFieldList = this.getPSModelObject().getPSDEMethodDTOFields();
		if (psDEMethodDTOFieldList != null) {
			for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
				psDEMethodDTOFieldMap.put(iPSDEMethodDTOField.getLowerCaseName(), iPSDEMethodDTOField);
				psDEMethodDTOFieldMap.put(iPSDEMethodDTOField.getName(), iPSDEMethodDTOField);
				if(iPSDEMethodDTOField.getPSDER() != null) {
					psDEMethodDTOFieldMap.put(iPSDEMethodDTOField.getPSDER().getId(), iPSDEMethodDTOField);
				}
			}
			
			if(isPreparePSDEFieldMap()) {
				psDEMethodDTOFieldMap2 = new HashMap<String, IPSDEMethodDTOField>();
				for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
					if(iPSDEMethodDTOField.getPSDEField()!=null) {
						psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getPSDEField().getLowerCaseName(), iPSDEMethodDTOField);
						psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getPSDEField().getName(), iPSDEMethodDTOField);
					}
					if(iPSDEMethodDTOField.getPSDER()!=null) {
						psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getLowerCaseName(), iPSDEMethodDTOField);
						psDEMethodDTOFieldMap2.put(iPSDEMethodDTOField.getPSDER().getId(), iPSDEMethodDTOField);
					}
				}
			}
		}
		
		super.onInit();
	}
	
	protected boolean isPreparePSDEFieldMap() {
		return true;
	}
	
	//@Override
	public boolean isEnableAny() {
		return true;
	}
	
	//@Override
	public IPSDEMethodDTOField getPSDEMethodDTOField(String strName, boolean bTryMode) throws Exception{
		IPSDEMethodDTOField iPSDEMethodDTOField = psDEMethodDTOFieldMap.get(strName);
		if(iPSDEMethodDTOField != null || bTryMode) {
			return iPSDEMethodDTOField;
		}
		throw new Exception(String.format("无法获取指定属性[%1$s]", strName));
	}

	//@Override
	public IPSDEMethodDTOField getPSDEMethodDTOFieldByDEField(IPSDEField iPSDEField, boolean bTryMode) throws Exception{
		IPSDEMethodDTOField iPSDEMethodDTOField = null;
		if(psDEMethodDTOFieldMap2 != null) {
			iPSDEMethodDTOField = psDEMethodDTOFieldMap2.get(iPSDEField.getName());
		}
		if(iPSDEMethodDTOField != null || bTryMode) {
			return iPSDEMethodDTOField;
		}
		throw new Exception(String.format("无法获取实体属性[%1$s]相关属性", iPSDEField.getName()));
	}
	
	//@Override
	public IPSDEMethodDTOField getPSDEMethodDTOFieldByDEField(String strName, boolean bTryMode) throws Exception{
		IPSDEMethodDTOField iPSDEMethodDTOField = null;
		if(psDEMethodDTOFieldMap2 != null) {
			iPSDEMethodDTOField = psDEMethodDTOFieldMap2.get(strName);
		}
		if(iPSDEMethodDTOField != null || bTryMode) {
			return iPSDEMethodDTOField;
		}
		throw new Exception(String.format("无法获取实体属性[%1$s]相关属性", strName));
	}
	
	
	//@Override
	public IPSDEMethodDTOField getPSDEMethodDTOFieldByDER(String strName, boolean bTryMode) throws Exception {
		IPSDEMethodDTOField iPSDEMethodDTOField = null;
		if(psDEMethodDTOFieldMap2 != null) {
			iPSDEMethodDTOField = psDEMethodDTOFieldMap2.get(strName);
		}
		if(iPSDEMethodDTOField != null || bTryMode) {
			return iPSDEMethodDTOField;
		}
		throw new Exception(String.format("无法获取实体关系[%1$s]相关属性", strName));
	}
	
	@Override
	public Object create(Object source) {
		return this.executeAction("建立对象", new IAction<Object>() {
			@Override
			public Object execute(Object[] args) throws Throwable {
				return onCreate(source);
			}
		});
	}
	
	protected Object onCreate(Object source) throws Throwable {
		Object iEntityBase = this.getUtil().createEntityDTO(this.getPSModelObject());
		if(source != null) {
			if(source instanceof Map) {
				Map<String, Object> map = (Map)source;
				for(java.util.Map.Entry<String, Object> entry : map.entrySet()) {
					this.set(iEntityBase, entry.getKey(), entry.getValue());
				}
			}
			else
				throw new Exception(String.format("无法识别的源对象[%1$s]", source));
		}
		return iEntityBase;
	}
	
	@Override
	public void set(Object obj, String strName, Object objValue) {
		this.executeAction("设置对象属性", new IAction<Object>() {
			@Override
			public Object execute(Object[] args) throws Throwable {
				onSet(obj, strName, objValue);
				return null;
			}
		});
	}
	
	protected void onSet(Object obj, String strName, Object objValue) throws Throwable {
		IPSDEMethodDTOField iPSDEMethodDTOField = this.getPSDEMethodDTOFieldByDEField(strName, true);
		if(iPSDEMethodDTOField == null) {
			if(this.isEnableAny()) {
				doSet(obj, strName, objValue);
			}
			else {
				log.warn(String.format("DTO对象[%1$s]不支持属性[%2$s]，无法设置值", this.getId(), strName));
			}
		}
		else {
			if(objValue != null) {
				if(DEMethodDTOFieldType.SIMPLE.value.equals(iPSDEMethodDTOField.getType())
						||DEMethodDTOFieldType.SIMPLES.value.equals(iPSDEMethodDTOField.getType())) {
					int nStdDataType = iPSDEMethodDTOField.getStdDataType();
					if(nStdDataType != DataTypes.UNKNOWN){
						try {
							if(DEMethodDTOFieldType.SIMPLE.value.equals(iPSDEMethodDTOField.getType())) {
								objValue = this.getUtil().convertValue(nStdDataType, objValue);
							}
							else {
								objValue = this.getUtil().convertListValue(nStdDataType, objValue);
							}
						} catch (Throwable ex) {
							throw new Exception(String.format("转化数据[%1$s]至[%2$s]发生异常，%3$s", objValue, DataTypeUtils.getTypeName(nStdDataType), ex.getMessage())	,ex);
						}
					}
				}
			}
			doSet(obj, iPSDEMethodDTOField, objValue);
		}
	}
	
	protected void doSet(Object obj, IPSDEMethodDTOField  iPSDEMethodDTOField, Object objValue) throws Throwable {
		this.doSet(obj, iPSDEMethodDTOField.getLowerCaseName(), objValue);
	}

	protected void doSet(Object obj, String strName, Object objValue) throws Throwable {
		if(obj instanceof IEntity) {
			((IEntity)obj).set(strName, objValue);
		}
		else {
			throw new Exception(String.format("未支持的对象[%1$s]", obj));
		}
	}

	@Override
	public void reset(Object obj, String strName) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resetAll(Object obj) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void copyTo(Object obj, Object dstParam) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Object get(Object obj, String strName) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean contains(Object obj, String strName) {
		// TODO Auto-generated method stub
		return false;
	}
	
	@Override
	public String toJsonSting(Object obj) {
		return this.executeAction("导出Json字符串", new IAction<String>() {
			@Override
			public String execute(Object[] args) throws Throwable {
				return onToJsonSting(obj);
			}
		}, String.class);
	}
	
	protected String onToJsonSting(Object obj) throws Throwable {
		return (String) this.getUtil().serialize(obj);
	}
}