package net.ibizsys.model.engine.dataentity.service;

import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.engine.IPSModelEngine;

public interface IPSDEMethodDTOEngine<M extends IPSDEMethodDTO> extends IPSModelEngine<M>{

	/**
	 * 建立数据对象
	 * @param source
	 * @return
	 */
	Object create(Object source);
	
	/**
	 * 设置指定属性值
	 * @param strName
	 * @param objValue
	 * @throws Throwable
	 */
	void set(Object obj, String strName, Object objValue) ;

	/**
	 * 重置指定属性变量
	 * @param strName
	 * @throws Throwable
	 */
	void reset(Object obj, String strName) ;

	/**
	 * 重置全部属性
	 * @param iDELogicSession
	 * @throws Throwable
	 */
	void resetAll(Object obj) ;

	/**
	 * 拷贝当前变量到指定变量
	 * @param dstParam
	 * @throws Throwable
	 */
	void copyTo(Object obj, Object dstParam) ;

	/**
	 * 获取指定属性值
	 * @param strName
	 * @return
	 * @throws Throwable
	 */
	Object get(Object obj, String strName) ;

	
	/**
	 * 判断是否包括指定属性
	 * @param iDELogicSession
	 * @param strName
	 * @return
	 * @throws Throwable
	 */
	boolean contains(Object obj, String strName) ;
	
	
	/**
	 * 转化为Json字符串
	 * @param obj
	 * @return
	 */
	String toJsonSting(Object obj);
}
