package net.ibizsys.model.engine.dataentity.logic;

import java.util.Map;


import org.apache.commons.text.StringSubstitutor;

import net.ibizsys.model.dataentity.logic.IPSDEThrowExceptionLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IEntity;

/**
 * 实体逻辑抛出异常节点运行时
 * @author lionlau
 *
 */
public class PSDELogicThrowExceptionNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEThrowExceptionLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEThrowExceptionLogic getPSDELogicNode() {
		return (IPSDEThrowExceptionLogic) super.getPSDELogicNode();
	}


	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEThrowExceptionLogic iPSDEThrowExceptionLogic = getPSDELogicNode();
		
		String strInfo = iPSDEThrowExceptionLogic.getErrorInfo();
		if(iPSDEThrowExceptionLogic.getExceptionParam() != null) {
			Object objParam = iPSDELogicSession.getLogicParamValue(iPSDEThrowExceptionLogic.getExceptionParam().getCodeName());
			Map map = null;
			if(objParam instanceof IEntity) {
				map = ((IEntity)objParam).any();
			}
			else
				if(objParam instanceof Map) {
					map = (Map)objParam;
				}
				
			if(map != null) {
				StringSubstitutor sub = new StringSubstitutor(map);
				sub.setVariablePrefix("{");
				sub.setVariableSuffix("}");
				strInfo = sub.replace(strInfo);
			}
		}
		
		
		throw new PSModelEngineAddinException(this, strInfo, iPSDEThrowExceptionLogic.getErrorCode());
	}
	
}