package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDESysUtilLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.sysutil.IPSSysUtilEngine;

/**
 * 实体逻辑调用系统预置功能组件运行时对象
 * @author lionlau
 *
 */
public class PSDELogicSysUtilNodeAddin extends PSDELogicNodeAddinBase<IPSDELogicEngine<?>, IPSDESysUtilLogic>{

//	@Override
//	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
//		if (!(data instanceof IPSDESysUtilLogic)) {
//			throw new Exception(String.format("模型类型不正确"));
//		}
//		super.init(iPSModelEngineHolder, iPSModelEngine, data);
//	}
//
//	@Override
//	public IPSDESysUtilLogic getPSDELogicNode() {
//		return (IPSDESysUtilLogic) super.getPSDELogicNode();
//	}


	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDESysUtilLogic iPSDESysLogicLogic = getPSDELogicNode();
		
		IPSSysUtilEngine dstPSSysUtilEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSDESysLogicLogic.getPSSysUtilMust(), IPSSysUtilEngine.class);
		
		Object objParam = null;
		Object objRet = null;
		if(iPSDESysLogicLogic.getDstPSDELogicParam() != null) {
			objParam = iPSDELogicSession.getLogicParamValue(iPSDESysLogicLogic.getDstPSDELogicParamMust().getCodeName());
			objRet = dstPSSysUtilEngine.executeAction(iPSDESysLogicLogic.getUtilAction(), new Object[] {objParam});
		}
		else {
			objRet = dstPSSysUtilEngine.executeAction(iPSDESysLogicLogic.getUtilAction(), null);
		}
		
		iPSDELogicSession.setLastReturn(objRet);
		if(iPSDESysLogicLogic.getRetPSDELogicParam() != null) {
			IPSDELogicParamAddin retDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDESysLogicLogic.getRetPSDELogicParam().getCodeName(), false);
			retDELogicParamRuntime.bind(iPSDELogicSession, objRet);
		}
	}
	
}
