package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;

/**
 * 系统相关逻辑参数引擎基类
 * @author lionlau
 *
 */
public abstract class PSDELogicSysParamAddinBase extends PSDELogicParamAddinBase{

	@Override
	public void bind(IPSDELogicSession iPSDELogicEngineSession, Object paramObject){
		try {
			this.onBind(iPSDELogicEngineSession, paramObject);
		}
		catch (Throwable ex) {
			throw new PSModelEngineAddinException(this, ex.getMessage(), ex);
		}
	}
	
	protected void onBind(IPSDELogicSession iPSDELogicEngineSession, Object paramObject) throws Throwable {
		throw new Exception("未支持bind操作");
	}
}
