package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDESysLogicLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.res.IPSSysLogicEngine;

/**
 * 实体逻辑调用系统预置逻辑节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicSysLogicNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDESysLogicLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDESysLogicLogic getPSDELogicNode() {
		return (IPSDESysLogicLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDESysLogicLogic iPSDESysLogicLogic = getPSDELogicNode();
		
		IPSSysLogicEngine dstPSSysLogicEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSDESysLogicLogic.getPSSysLogicMust(), IPSSysLogicEngine.class);
		
		Object objParam = null;
		Object objRet = null;
		if(iPSDESysLogicLogic.getDstPSDELogicParam() != null) {
			objParam = iPSDELogicSession.getLogicParamValue(iPSDESysLogicLogic.getDstPSDELogicParamMust().getCodeName());
		}
		objRet = dstPSSysLogicEngine.execute(new Object[] {objParam, iPSDESysLogicLogic.getLogicParam(), iPSDESysLogicLogic.getLogicParam2()});
		
		iPSDELogicSession.setLastReturn(objRet);
		if(iPSDESysLogicLogic.getRetPSDELogicParam() != null) {
			IPSDELogicParamAddin retDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDESysLogicLogic.getRetPSDELogicParam().getCodeName(), false);
			retDELogicParamRuntime.bind(iPSDELogicSession, objRet);
		}
		
	}
	
}
