package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDESysDataSyncAgentOutLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.eai.IPSSysDataSyncAgentEngine;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;

/**
 * 实体调用系统数据同步代理输出节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicSysDataSyncAgentOutNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDESysDataSyncAgentOutLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDESysDataSyncAgentOutLogic getPSDELogicNode() {
		return (IPSDESysDataSyncAgentOutLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDESysDataSyncAgentOutLogic iPSDESysDataSyncAgentOutLogic = getPSDELogicNode();
		
		IPSSysDataSyncAgentEngine dstPSSysDataSyncAgentEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSDESysDataSyncAgentOutLogic.getPSSysDataSyncAgentMust(), IPSSysDataSyncAgentEngine.class);
		
		
		Object objParam = iPSDELogicSession.getLogicParamValue(iPSDESysDataSyncAgentOutLogic.getDstPSDELogicParamMust().getCodeName());
		
		if(!dstPSSysDataSyncAgentEngine.isRawDataMode()) {
			throw new PSModelEngineAddinException(this, String.format("数据同步代理[%1$s]类型不正确，仅支持直接发送", iPSDESysDataSyncAgentOutLogic.getPSSysDataSyncAgentMust().getName()));
		}
		
//		DataSyncOut dataSyncOut = new DataSyncOut();
//		dataSyncOut.setData(DataTypeUtils.getStringValue(iDELogicRuntimeContext.getSystemRuntime().serialize(objParam), null));
//		dataSyncOut.setCreateDate(new java.sql.Timestamp(System.currentTimeMillis()));
		
		dstPSSysDataSyncAgentEngine.send(new Object[] {objParam});
		
	}
	
}
