package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDESubSysSAMethodLogic;
import net.ibizsys.model.engine.service.IPSSubSysServiceAPIDEMethodEngine;
import net.ibizsys.model.engine.util.NavigateContextHolder;

/**
 * 实体调用外部服务接口节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicSubSysSAMethodNodeAddin extends PSDELogicNodeAddinBase<IPSDELogicEngine<?>, IPSDESubSysSAMethodLogic>{

//	@Override
//	public IPSDESubSysSAMethodLogic getPSDELogicNode() {
//		return (IPSDESubSysSAMethodLogic) super.getPSDELogicNode();
//	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDESubSysSAMethodLogic iPSDESubSysSAMethodLogic = getPSDELogicNode();
		
		
		Object objParam = iPSDELogicSession.getLogicParamValue(iPSDESubSysSAMethodLogic.getDstPSDELogicParamMust().getCodeName());
		
		IPSSubSysServiceAPIDEMethodEngine<?> iPSSubSysServiceAPIDEMethodEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSDESubSysSAMethodLogic.getPSSubSysServiceAPIDEMethodMust(), IPSSubSysServiceAPIDEMethodEngine.class);
	
		Object objRet = iPSSubSysServiceAPIDEMethodEngine.execute(NavigateContextHolder.getCurrent(), new Object[] {objParam}); 
		
		iPSDELogicSession.setLastReturn(objRet);
		
		if(iPSDESubSysSAMethodLogic.getRetPSDELogicParam() != null) {
			IPSDELogicParamAddin retDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDESubSysSAMethodLogic.getRetPSDELogicParam().getCodeName(), false);
			retDELogicParamRuntime.bind(iPSDELogicSession, objRet);
		}
	}
	
}
