package net.ibizsys.model.engine.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.dataentity.logic.IPSDESortParamLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;

/**
 * 实体排序列表逻辑参数节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicSortParamNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDESortParamLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDESortParamLogic getPSDELogicNode() {
		return (IPSDESortParamLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDESortParamLogic iPSDESortParamLogic = getPSDELogicNode();
		
		IPSDELogicParamAddin dstPSDELogicParamEngine = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDESortParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		String strDstFieldName = iPSDESortParamLogic.getDstFieldName();
		if(!StringUtils.hasLength(iPSDESortParamLogic.getDstFieldName())) {
			throw new PSModelEngineAddinException(this, String.format("未指定设置排序属性"));
		}
		dstPSDELogicParamEngine.sort(iPSDELogicSession, strDstFieldName, iPSDESortParamLogic.getDstSortDir());
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("排序数组参数[%1$s] <== %2$s, %3$s", dstPSDELogicParamEngine.getCodeName(), strDstFieldName, iPSDESortParamLogic.getDstSortDir()));
		}
		
		iPSDELogicSession.setLastReturn(null);
	}
	
}
