package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.util.DataTypeUtils;

/**
 * 简单数据类型参数运行时对象实现
 * @author lionlau
 *
 */
public class PSDELogicSimpleParamAddin extends PSDELogicParamAddinBase{

	@Override
	public void bind(IPSDELogicSession iDELogicSession, Object paramObject) {
		
		if(paramObject != null) {
			//判断是否为简单类型
			Object objValue = DataTypeUtils.asSimple(paramObject);
			if(objValue!=null) {
				super.bind(iDELogicSession, objValue);
				return;
			}
			
			throw new PSModelEngineAddinException(this, String.format("无法绑定非简单数据类型参数[%1$s]", paramObject.getClass().getName()));
		}
		else {
			super.bind(iDELogicSession, paramObject);
		}
	}
	
	@Override
	public Object getValue(IPSDELogicSession iDELogicSession) {
		try {
			return iDELogicSession.getParam(this.getPSDELogicParam(), true);
		} catch (Exception ex) {
			// TODO Auto-generated catch block
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
	}
}
