package net.ibizsys.model.engine.dataentity.logic;

import java.util.ArrayList;
import java.util.List;

import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;

/**
 * 简单数据类型列表参数运行时对象实现
 * @author lionlau
 *
 */
public class PSDELogicSimpleListParamAddin extends PSDELogicParamAddinBase{


	@Override
	public Object getValue(IPSDELogicSession iDELogicSession){
		Object object = null;
		try {
			object = iDELogicSession.getParam(this.getPSDELogicParam(), true);
			if (object != null) {
				// 检查类型是否正确
				if (!(object instanceof List)) {
					throw new Exception(String.format("值不是数据对象列表类型"));
				}
				return object;
			}
		}
		catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
		
		// 新建
		object = new ArrayList<Object>();
		iDELogicSession.setParam(this.getPSDELogicParam(), object);
		return object;
	}

	@Override
	public void bind(IPSDELogicSession iDELogicSession, Object paramObject){
		List srcList = null;
		if (paramObject != null) {
			// 检查类型是否正确
			srcList = asList(paramObject);
			if (srcList == null) {
				try {
					srcList = this.getUtil().deserialize(paramObject, List.class);
				}
				catch(Throwable ex) {
					throw new PSModelEngineAddinException(this, String.format("逻辑参数无法绑定非数据对象列表类型参数"));
				}
			}
		}
		super.bind(iDELogicSession, srcList);
	}

	@Override
	public int count(IPSDELogicSession iDELogicSession){
		Object obj;
		try {
			obj = iDELogicSession.getParam(this.getPSDELogicParam(), true);
			if (obj == null) {
				return 0;
			}
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
		

		obj = this.getValue(iDELogicSession);
		if (obj instanceof List) {
			return ((List) obj).size();
		}
		return super.count(iDELogicSession);
	}
	
	@Override
	public void resetAll(IPSDELogicSession iDELogicSession){
		Object obj;
		try {
			obj = iDELogicSession.getParam(this.getPSDELogicParam(), true);
			if (obj == null) {
				return;
			}
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
		
		obj = this.getValue(iDELogicSession);
		if (obj instanceof List) {
			((List)obj).clear();
			return;
		}
		
		super.resetAll(iDELogicSession);
	}
}
