package net.ibizsys.model.engine.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.ActionSessionHolder;

/**
 * 处理逻辑会话参数对象
 * 
 * @author lionlau
 *
 */
public class PSDELogicSessionParamAddin extends PSDELogicParamAddinBase {

	private String strSessionTag = null;

	@Override
	protected void onInit() throws Exception {
		String strParamTag = this.getPSDELogicParam().getParamTag();
		if(StringUtils.isEmpty(strParamTag)) {
			strParamTag = this.getCodeName();
		}
		this.strSessionTag = String.format("DELOGIC_%1$s", strParamTag);
		super.onInit();
	}

	public String getSessionTag() {
		return this.strSessionTag;
	}
	
//	@Override
//	public Object getParamObject(IPSDELogicSession iDELogicSession){
//		Object object = ActionSessionHolder.getCurrentMust().getParam(getSessionTag());
//		if (object == null) {
//			if (this.getPSDELogicParam().getParamPSDataEntity() == null) {
//				object = this.getPSModelEngineHolder().getPSSystemEngine().createEntity();
//			} else {
//				object = this.getPSModelEngineHolder().getPSSystemEngine().createEntityDTO(this.getPSDELogicParam().getParamPSDataEntity());
//			}
//			ActionSessionHolder.getCurrentMust().setParam(getSessionTag(), object);
//		}
//		return object;
//	}

	@Override
	public void bind(IPSDELogicSession iDELogicSession, Object paramObject){
		try {
			ActionSessionHolder.getCurrentMust().setParam(getSessionTag(), paramObject);
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("绑定值发生异常，%1$s", ex.getMessage()), ex);
		}
	}
	

}
