package net.ibizsys.model.engine.dataentity.logic;

public class PSDELogicSessionHolder {

	private static ThreadLocal<IPSDELogicSession> current = new ThreadLocal<IPSDELogicSession>();

	
	public static IPSDELogicSession getCurrent() {
		return current.get();
	}
	
	public static IPSDELogicSession getCurrentMust() {
		IPSDELogicSession iPSDELogicEngineSession = current.get();
		if(iPSDELogicEngineSession == null) {
			throw new RuntimeException("当前逻辑引擎会话无效");
		}
		return iPSDELogicEngineSession;
	}
	
	public static void setCurrent(IPSDELogicSession iPSDELogicEngineSession) {
		current.set(iPSDELogicEngineSession);
	}
	
	
}
