package net.ibizsys.model.engine.dataentity.logic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

import net.ibizsys.model.PSModelEnums.DELogicDebugMode;
import net.ibizsys.model.PSModelEnums.DELogicParamValueType;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.engine.security.SecurityContextHolder;
import net.ibizsys.model.util.DateUtils;

public abstract class PSDELogicSessionBase implements IPSDELogicSession{

	private static final Log log = LogFactory.getLog(PSDELogicSession.class);
	
	private Map<String, Object> paramMap = new HashMap<>();
	private Object result = null;
	private Object lastReturn = null;
	private IPSDELogicEngine iPSDELogicEngine = null;
	//private IAppContext iAppContext = null;
	
	private List debugData = null;
	
	private int debugMode = DELogicDebugMode.NONE.value;

	public PSDELogicSessionBase(IPSDELogicEngine iPSDELogicEngine) {
		this.iPSDELogicEngine = iPSDELogicEngine;
		this.setDebugMode(iPSDELogicEngine.getPSDELogic().getDebugMode());
		this.debugData = new ArrayList<>();
	}
	
	@Override
	public IPSDELogicEngine getPSDELogicEngine() {
		return this.iPSDELogicEngine;
	}
	
	@Override
	public int getDebugMode() {
		return this.debugMode;
	}
	
	protected void setDebugMode(int debugMode) {
		this.debugMode = debugMode;
	}
	
	@Override
	public boolean isOutputDebugInfo() {
		return getDebugMode() == DELogicDebugMode.INFO.value;
	}
	

	@Override
	public Object getParam(String strName) throws Exception {
		return this.getParam(strName, false);
	}

	@Override
	public void setParam(String strName, Object object) {
		paramMap.put(strName, object);
	}

	@Override
	public Object getParam(String strName, boolean bTryMode) throws Exception {
		Object obj =  paramMap.get(strName);
		if(obj != null || bTryMode) {
			return obj;
		}
		throw new Exception(String.format("未存在指定参数[%1$s]", strName));
	}


	@Override
	public Object getResult() {
		return this.result;
	}

	@Override
	public void setResult(Object result) {
		this.result = result;
	}

	@Override
	public Object getLastReturn() {
		return this.lastReturn;
	}

	@Override
	public void setLastReturn(Object lastReturn) {
		this.lastReturn = lastReturn;
	}

	@Override
	public void debugEnterNode(IPSDELogicNode iPSDELogicNode) {
		
		if(log.isDebugEnabled()) {
			log.debug(String.format("进入节点[%1$s]", iPSDELogicNode.getName()));
		}
		
		if(getDebugData() == null) {
			return;
		}
		
		Map<String, Object> data = new LinkedHashMap<String, Object>();
		data.put("type", "enternode");
		data.put("time", DateUtils.getCurTimeString2());
		data.put("name", iPSDELogicNode.getName());
		data.put("codeName", iPSDELogicNode.getCodeName());
		
		this.getDebugData().add(data);
	}

	@Override
	public void debugExitNode(IPSDELogicNode iPSDELogicNode) {
		
		if(log.isDebugEnabled()) {
			log.debug(String.format("离开节点[%1$s]", iPSDELogicNode.getName()));
		}
		
		if(getDebugData() == null) {
			return;
		}
		
		Map<String, Object> data = new LinkedHashMap<String, Object>();
		data.put("type", "exitnode");
		data.put("time", DateUtils.getCurTimeString2());
		data.put("name", iPSDELogicNode.getName());
		data.put("codeName", iPSDELogicNode.getCodeName());
		
		this.getDebugData().add(data);
	}
	


	@Override
	public void debugEnterLink(IPSDELogicNode iPSDELogicNode, IPSDELogicLink iPSDELogicLink) {
		
		
		if(log.isDebugEnabled()) {
			log.debug(String.format("进入连接[%1$s@%2$s]", iPSDELogicLink.getName(), iPSDELogicNode.getName()));
		}
		
		
		if(getDebugData() == null) {
			return;
		}
		
		Map<String, Object> data = new LinkedHashMap<String, Object>();
		data.put("type", "enterlink");
		data.put("time", DateUtils.getCurTimeString2());
		data.put("name", String.format("%1$s@%2$s", iPSDELogicLink.getName(), iPSDELogicNode.getName()));
		
		this.getDebugData().add(data);
		
	}



	@Override
	public void debugParam(IPSDELogicParam iPSDELogicParam) {
		
		if(getDebugData() == null) {
			return;
		}
		
		Map<String, Object> data = new LinkedHashMap<String, Object>();
		data.put("type", "debugparam");
		data.put("time", DateUtils.getCurTimeString2());

		IPSDELogicParamAddin iPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicParam.getCodeName(), false);
		iPSDELogicParamAddin.debug(this, data);
		
		this.getDebugData().add(data);
		
		if(log.isDebugEnabled()) {
			log.debug(String.format("输出参数[%1$s]\r\n%2$s", iPSDELogicParamAddin.getName(), data));
		}
		
	}
	
	@Override
	public void debugInfo(String strInfo) {
		if(log.isDebugEnabled()) {
			log.debug(strInfo);
		}
		
		if(getDebugData() == null) {
			return;
		}
		
		Map<String, Object> data = new LinkedHashMap<String, Object>();
		data.put("type", "debuginfo");
		data.put("time", DateUtils.getCurTimeString2());
		data.put("info", strInfo);
		
		this.getDebugData().add(data);
	}
	
	
	public List getDebugData() {
		return this.debugData;
	}

	
	@Override
	public Object getNodeParamValue(IPSDELogicNodeParam iPSDELogicNodeParam) throws Exception {
		
		if(DELogicParamValueType.SRCDLPARAM.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
			IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
			if(ObjectUtils.isEmpty(iPSDELogicNodeParam.getSrcFieldName())) {
				return srcPSDELogicParamAddin.getValue(this);
			}
			return srcPSDELogicParamAddin.get(this, iPSDELogicNodeParam.getSrcFieldName().toLowerCase());
		}
		
		if(DELogicParamValueType.NULLVALUE.value.equals(iPSDELogicNodeParam.getSrcValueType())) {			
			return null;
		}

		if(DELogicParamValueType.SRCVALUE.value.equals(iPSDELogicNodeParam.getSrcValueType())) {			
			return iPSDELogicNodeParam.getSrcValue();
		}
		
		if(DELogicParamValueType.SESSION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {	
			if(ObjectUtils.isEmpty(iPSDELogicNodeParam.getSrcFieldName())) {
				throw new Exception(String.format("处理节点参数[%1$s]未指定源属性名称", iPSDELogicNodeParam.getName()));
			}
			
			if(SecurityContextHolder.getCurrent() == null) {
				throw new Exception(String.format("安全上下文对象无效"));
			}
			
			return SecurityContextHolder.getCurrent().getSessionValue(iPSDELogicNodeParam.getSrcFieldName());
		}
		
		
		if(DELogicParamValueType.APPLICATION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {	
			if(ObjectUtils.isEmpty(iPSDELogicNodeParam.getSrcFieldName())) {
				throw new Exception(String.format("处理节点参数[%1$s]未指定源属性名称", iPSDELogicNodeParam.getName()));
			}
			
			// 系统全局对象属性
			//return this.getPSDELogicEngine()().getGlobalParam(iPSDELogicNodeParam.getSrcFieldName());
			throw new Exception(String.format("没有实现"));
		}
		
		if(DELogicParamValueType.EXPRESSION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {	
//			if(ObjectUtils.isEmpty(iPSDELogicNodeParam.getExpression())) {
//				throw new DataEntityRuntimeException(this.getDataEntityRuntime(), this, String.format("处理节点参数[%1$s]未指定表达式", iPSDELogicNodeParam.getName()));
//			}
//			IDELogicScriptNodeRuntime iDELogicScriptNodeRuntime = this.getDEScriptLogicRuntime(iPSDELogicNodeParam.getParentPSModelObject(IPSDELogicNode.class, false), iPSDELogicNodeParam.getExpression(), IDELogicScriptNodeRuntime.MODE_EXPRESSION, false);
//			return iDELogicScriptNodeRuntime.execute(iDELogicRuntimeContext, this, iPSDELogicNodeParam);
			throw new Exception("没有实现");
		}
			
		if(DELogicParamValueType.COUNT.value.equals(iPSDELogicNodeParam.getSrcValueType())) {	
			IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
			return srcPSDELogicParamAddin.count(this);
		}
		
		if(DELogicParamValueType.AGGREGATION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {	
			IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
			
			if(ObjectUtils.isEmpty(iPSDELogicNodeParam.getSrcFieldName())) {
				throw new Exception(String.format("处理节点参数[%1$s]未指定源属性名称", iPSDELogicNodeParam.getName()));
			}
			
			if(ObjectUtils.isEmpty(iPSDELogicNodeParam.getAggMode())) {
				throw new Exception(String.format("处理节点参数[%1$s]未指定聚合模式", iPSDELogicNodeParam.getName()));
			}
			
			return srcPSDELogicParamAddin.aggregate(this, iPSDELogicNodeParam.getSrcFieldName(), iPSDELogicNodeParam.getAggMode());
		}
		
		/**
		 * 以下实现暂时忽略，模型后续调整为取源值
		 */
//		if(DELogicParamValueType.TRANSLATOR.equals(iPSDELogicNodeParam.getSrcValueType())) {	
//			
//			ISysTranslatorRuntime iSysTranslatorRuntime = this.getSystemRuntime().getSysTranslatorRuntime(iPSDELogicNodeParam.getPSSysTranslatorMust());
//			
//			IPSDELogicParamAddin dstPSDELogicParamAddin = this.getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
//			if(ObjectUtils.isEmpty(iPSDELogicNodeParam.getDstFieldName())) {
//				throw new DataEntityRuntimeException(this.getDataEntityRuntime(), this, String.format("处理节点参数[%1$s]未指定目标属性名称", iPSDELogicNodeParam.getName()));
//			}
//			
//			Object objValue = dstPSDELogicParamAddin.get(this, iPSDELogicNodeParam.getDstFieldName());
//			
//			Object objEntity = dstPSDELogicParamAddin.getParamObject(this);
//			IEntityBase iEntityBase = null;
//			if(objEntity instanceof IEntityBase) {
//				iEntityBase = (IEntityBase)objEntity;
//			}
//			
//			IDataEntityRuntime iDataEntityRuntime = dstPSDELogicParamAddin.getDataEntityRuntime();
//			IPSDEField iPSDEField = null;
//			if(iDataEntityRuntime!=null) {
//				iPSDEField = iDataEntityRuntime.getPSDEField(iPSDELogicNodeParam.getDstFieldName(), true);
//			}
//			
//			return iSysTranslatorRuntime.translate(objValue, true, iEntityBase, iPSDEField, iDataEntityRuntime);
//		}
//		
//		if(DELogicParamValueType.SEQUENCE.equals(iPSDELogicNodeParam.getSrcValueType())) {
//			ISysSequenceRuntime iSysSequenceRuntime = this.getSystemRuntime().getSysSequenceRuntime(iPSDELogicNodeParam.getPSSysSequenceMust());
//			
//			IPSDELogicParamAddin dstPSDELogicParamAddin = this.getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
//			if(ObjectUtils.isEmpty(iPSDELogicNodeParam.getDstFieldName())) {
//				throw new DataEntityRuntimeException(this.getDataEntityRuntime(), this, String.format("处理节点参数[%1$s]未指定目标属性名称", iPSDELogicNodeParam.getName()));
//			}
//			
//			Object objEntity = dstPSDELogicParamAddin.getParamObject(this);
//			IEntityBase iEntityBase = null;
//			if(objEntity instanceof IEntityBase) {
//				iEntityBase = (IEntityBase)objEntity;
//			}
//			
//			IDataEntityRuntime iDataEntityRuntime = dstPSDELogicParamAddin.getDataEntityRuntime();
//			IPSDEField iPSDEField = null;
//			if(iDataEntityRuntime!=null) {
//				iPSDEField = iDataEntityRuntime.getPSDEField(iPSDELogicNodeParam.getDstFieldName(), true);
//			}
//			
//			return iSysSequenceRuntime.get(iEntityBase, iPSDEField, iDataEntityRuntime);
//		}
		
		
		throw new Exception(String.format("处理节点参数[%1$s]源值类型[%2$s]未支持", iPSDELogicNodeParam.getName(), iPSDELogicNodeParam.getSrcValueType()));
	}
	
	
	/**
	 * 获取逻辑参数实际值
	 * @param strLogicParamCodeName
	 * @return
	 * @throws Throwable
	 */
	@Override
	public Object getLogicParamValue(String strLogicParamCodeName) throws Exception {
		IPSDELogicParamAddin iPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(strLogicParamCodeName, false);
		return iPSDELogicParamAddin.getValue(this);
	}

	@Override
	public Object getParam(IPSDELogicParam iPSDELogicParam) throws Exception {
		String name = String.format("_LogicParam_%1$s", iPSDELogicParam.getCodeName());
		return this.getParam(name);
	}

	@Override
	public void setParam(IPSDELogicParam iPSDELogicParam, Object value) {
		String name = String.format("_LogicParam_%1$s", iPSDELogicParam.getCodeName());
		this.setParam(name, value);
	}

	@Override
	public Object getParam(IPSDELogicParam iPSDELogicParam, boolean tryMode) throws Exception {
		String name = String.format("_LogicParam_%1$s", iPSDELogicParam.getCodeName());
		return this.getParam(name, tryMode);
	}

	

}
