package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDEResetParamLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;

/**
 * 实体重置逻辑参数节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicResetParamNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEResetParamLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEResetParamLogic getPSDELogicNode() {
		return (IPSDEResetParamLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEResetParamLogic iPSDEResetParamLogic = getPSDELogicNode();
		
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEResetParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		dstDELogicParamRuntime.resetAll(iPSDELogicSession);
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("重置参数[%1$s]", dstDELogicParamRuntime.getCodeName()));
		}
		
		iPSDELogicSession.setLastReturn(null);
	}
	
}
