package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDERenewParamLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;

/**
 * 实体重建逻辑参数节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicRenewParamNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDERenewParamLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDERenewParamLogic getPSDELogicNode() {
		return (IPSDERenewParamLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDERenewParamLogic iPSDERenewParamLogic = getPSDELogicNode();
		
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDERenewParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		dstDELogicParamRuntime.renew(iPSDELogicSession);
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("重建参数[%1$s]", dstDELogicParamRuntime.getCodeName()));
		}
		
		iPSDELogicSession.setLastReturn(null);
	}
	
}
