package net.ibizsys.model.engine.dataentity.logic;

import java.util.ArrayList;
import java.util.List;

import net.ibizsys.model.PSModelEnums.DELogicNodeParamType;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;

/**
 * 直接SQL调用节点运行时基类
 * 
 * @author lionlau
 *
 */
public abstract class PSDELogicRawSqlCallNodeAddinBase extends PSDELogicNodeAddinBase {

	/**
	 * 获取Sql参数列表
	 * 
	 * @param iPSDELogicSession
	 * @return
	 * @throws Throwable
	 */
	protected List<Object> getSqlParamList(IPSDELogicSession iPSDELogicSession) throws Throwable {
		java.util.List<IPSDELogicNodeParam> psDELogicNodeParamList = this.getPSDELogicNode().getPSDELogicNodeParams();
		if (psDELogicNodeParamList == null || psDELogicNodeParamList.size() == 0) {
			return null;
		}
		List<Object> list = new ArrayList<Object>();
		for (IPSDELogicNodeParam iPSDELogicNodeParam : psDELogicNodeParamList) {
			String strParamAction = iPSDELogicNodeParam.getParamAction();
			if (DELogicNodeParamType.SQLPARAM.value.equals(strParamAction)) {
				list.add(this.calcPSDELogicNodeParamValue(iPSDELogicSession, iPSDELogicNodeParam));
			}
		}

		return list;
	}

}
