package net.ibizsys.model.engine.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.PSModelEnums.DELogicNodeParamType;
import net.ibizsys.model.PSModelEnums.DELogicParamValueType;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.engine.res.IPSSysTranslatorEngine;
import net.ibizsys.model.res.IPSSysTranslator;

/**
 * 实体逻辑准备参数节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicPrepareParamNodeAddin extends PSDELogicNodeAddinBase<IPSDELogicEngine<?>, IPSDELogicNode>{

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSDELogicPrepareParamNodeAddin.class);
	
	
	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		java.util.List<IPSDELogicNodeParam> psDELogicNodeParamList = this.getPSDELogicNode().getPSDELogicNodeParams();
		if(psDELogicNodeParamList == null || psDELogicNodeParamList.size() == 0) {
			//throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format(arg0, arg1)., strInfo);
			return;
		}
		
		for(IPSDELogicNodeParam iPSDELogicNodeParam : psDELogicNodeParamList) {
			String strParamAction = iPSDELogicNodeParam.getParamAction();
			if(DELogicNodeParamType.SETPARAMVALUE.value.equals(strParamAction)) {
				onSetParamValue(iPSDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamType.RESETPARAM.value.equals(strParamAction)) {
				onResetParam(iPSDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamType.COPYPARAM.value.equals(strParamAction)) {
				continue;
			}
			
			if(DELogicNodeParamType.BINDPARAM.value.equals(strParamAction)) {
				onBindParam(iPSDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamType.RENEWPARAM.value.equals(strParamAction)) {
				onRenewParam(iPSDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamType.APPENDPARAM.value.equals(strParamAction)) {
				onAppendParam(iPSDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamType.SORTPARAM.value.equals(strParamAction)) {
				onSortParam( iPSDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			log.warn(String.format("未支持的参数设置操作[%1$s]", strParamAction));
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("未支持的参数设置操作[%1$s]", strParamAction));
			}
		}
	}
	

	
	protected void onCopyParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IPSDELogicParamAddin srcDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		srcDELogicParamRuntime.copyTo(iPSDELogicSession, dstDELogicParamRuntime.getValue(iPSDELogicSession));
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("拷贝参数[%1$s] ==> %2$s", srcDELogicParamRuntime.getCodeName(), dstDELogicParamRuntime.getCodeName()));
		}
	}
	
	
	
	protected void onBindParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IPSDELogicParamAddin srcDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		String strSrcFieldName = iPSDELogicNodeParam.getSrcFieldName();
		Object objValue = null;
		if(StringUtils.hasLength(strSrcFieldName)){
			objValue = srcDELogicParamRuntime.get(iPSDELogicSession, strSrcFieldName);
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("源参数[%1$s]属性[%2$s] ==> %3$s", srcDELogicParamRuntime.getCodeName(), strSrcFieldName, objValue));
			}
		}
		else {
			objValue = srcDELogicParamRuntime.getValue(iPSDELogicSession);
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("源参数[%1$s] ==> %2$s", srcDELogicParamRuntime.getCodeName(), objValue));
			}
		}
		
		
		IPSSysTranslator iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator();
		if(iPSSysTranslator!=null) {
			IPSSysTranslatorEngine<?> iPSSysTranslatorEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSSysTranslator, IPSSysTranslatorEngine.class);
			objValue = iPSSysTranslatorEngine.translate(objValue, !iPSDELogicNodeParam.isOutTranslate());
			
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("转换器[%1$s]值输入转换 ==> %2$s", iPSSysTranslatorEngine.getName(), objValue));
			}
		}
		dstDELogicParamRuntime.bind(iPSDELogicSession, objValue);
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("绑定参数[%1$s] <== %2$s", dstDELogicParamRuntime.getCodeName(), objValue));
		}
	}
	
	
	protected void onRenewParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		dstDELogicParamRuntime.renew(iPSDELogicSession);
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("重建参数[%1$s]", dstDELogicParamRuntime.getCodeName()));
		}
	}
	
	protected void onResetParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		dstDELogicParamRuntime.resetAll(iPSDELogicSession);
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("重置参数[%1$s]", dstDELogicParamRuntime.getCodeName()));
		}
	}
	
	
	protected void onSetParamValue(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		
		if(!StringUtils.hasLength(iPSDELogicNodeParam.getDstFieldName())) {
			throw new Exception(String.format("处理节点参数[%1$s]未指定设置目标属性", iPSDELogicNodeParam.getName()));
		}
		
		
		if(DELogicParamValueType.NONEVALUE.value.equals(iPSDELogicNodeParam.getSrcValueType())) {			
		//	dstEntity.reset(iPSDELogicNodeParam.getDstFieldName().toLowerCase());
			dstDELogicParamRuntime.reset(iPSDELogicSession, iPSDELogicNodeParam.getDstFieldName().toLowerCase());
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("重置参数[%1$s]属性[%2$s]", dstDELogicParamRuntime.getCodeName(), iPSDELogicNodeParam.getDstFieldName()));
			}
			return ;
		}
		
		Object objValue = this.calcPSDELogicNodeParamValue(iPSDELogicSession, iPSDELogicNodeParam);
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("计算节点参数[%1$s] ==> %2$s", iPSDELogicNodeParam.getName(), objValue));
		}
		
		IPSSysTranslator iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator();
		if(iPSSysTranslator!=null) {
			IPSSysTranslatorEngine<?> iPSSysTranslatorEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSSysTranslator, IPSSysTranslatorEngine.class);
			objValue = iPSSysTranslatorEngine.translate(objValue, !iPSDELogicNodeParam.isOutTranslate());
			
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("转换器[%1$s]值输入转换 ==> %2$s", iPSSysTranslatorEngine.getName(), objValue));
			}
		}
		dstDELogicParamRuntime.set(iPSDELogicSession, iPSDELogicNodeParam.getDstFieldName().toLowerCase(), objValue);
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("设置参数[%1$s]属性[%2$s] <== %3$s", dstDELogicParamRuntime.getCodeName(), iPSDELogicNodeParam.getDstFieldName(), objValue));
		}
		return ;
	}
	
	protected void onAppendParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		IPSDELogicParamAddin srcDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
		String strSrcFieldName = iPSDELogicNodeParam.getSrcFieldName();
		Object objValue = null;
		if(StringUtils.hasLength(strSrcFieldName)){
			objValue =  srcDELogicParamRuntime.get(iPSDELogicSession, strSrcFieldName);
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("源参数[%1$s]属性[%2$s] ==> %3$s", srcDELogicParamRuntime.getCodeName(), strSrcFieldName, objValue));
			}
		}
		else {
			objValue = srcDELogicParamRuntime.getValue(iPSDELogicSession);
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("源参数[%1$s] ==> %2$s", srcDELogicParamRuntime.getCodeName(), objValue));
			}
		}
		IPSSysTranslator iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator();
		if(iPSSysTranslator!=null) {
			IPSSysTranslatorEngine<?> iPSSysTranslatorEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSSysTranslator, IPSSysTranslatorEngine.class);
			objValue = iPSSysTranslatorEngine.translate(objValue, !iPSDELogicNodeParam.isOutTranslate());
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("转换器[%1$s]值输入转换 ==> %2$s", iPSSysTranslatorEngine.getName(), objValue));
			}
		}
		dstDELogicParamRuntime.append(iPSDELogicSession, iPSDELogicNodeParam.getDstIndex(), objValue, iPSDELogicNodeParam.getSrcIndex(), iPSDELogicNodeParam.getSrcSize());
		if(iPSDELogicSession.isOutputDebugInfo()) {
			if(iPSDELogicNodeParam.getSrcIndex() >= 0 ) {
				iPSDELogicSession.debugInfo(String.format("附加数组参数[%1$s][%2$s] <== %3$s{%4$s, %5$s}", dstDELogicParamRuntime.getCodeName(), iPSDELogicNodeParam.getDstIndex(), objValue, iPSDELogicNodeParam.getSrcIndex(), iPSDELogicNodeParam.getSrcSize()));
			}
			else {
				iPSDELogicSession.debugInfo(String.format("附加数组参数[%1$s][%2$s] <== %3$s", dstDELogicParamRuntime.getCodeName(), iPSDELogicNodeParam.getDstIndex(), objValue));
			}
		}
	}
	
	protected void onSortParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		String strDstFieldName = iPSDELogicNodeParam.getDstFieldName();
		if(!StringUtils.hasLength(iPSDELogicNodeParam.getDstFieldName())) {
			throw new Exception(String.format("处理节点参数[%1$s]未指定设置排序属性", iPSDELogicNodeParam.getName()));
		}
		dstDELogicParamRuntime.sort(iPSDELogicSession, strDstFieldName, iPSDELogicNodeParam.getDstSortDir());
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("排序数组参数[%1$s] <== %2$s, %3$s", dstDELogicParamRuntime.getCodeName(), strDstFieldName, iPSDELogicNodeParam.getDstSortDir()));
		}
	}
}
