package net.ibizsys.model.engine.dataentity.logic;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import org.springframework.util.ObjectUtils;

import net.ibizsys.model.PSModelEnums.DER1NDEFMapType;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.engine.plugin.PSModelEngineAddin2Base;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IEntity;
import net.ibizsys.model.engine.util.IEntityDTO;
import net.ibizsys.model.engine.util.IPage;
import net.ibizsys.model.util.DataTypeUtils;

public abstract class PSDELogicParamAddinBase<E extends IPSDELogicEngine<?>, M extends IPSDELogicParam> extends PSModelEngineAddin2Base<E, M> implements IPSDELogicParamAddin<E, M> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSDELogicParamAddinBase.class);
	
//	private IDataEntityRuntime iDataEntityRuntime = null;
	private String strCodeName = null;
	
	@Override
	protected void onInit() throws Exception {
		this.strCodeName = this.getPSDELogicParam().getCodeName();
		super.onInit();
	}

	//@Override
	protected M getPSDELogicParam() {
		return this.getAddinData();
	}
	
//	@Override
//	protected IPSDELogicParam getAddinData() {
//		return (IPSDELogicParam)super.getAddinData();
//	}
	
	
	
	@Override
	public String getCodeName() {
		return this.strCodeName;
	}
	
	
	@Override
	public String getName() {
		return String.format("逻辑参数[%1$s]", this.getPSDELogicParam().getName());
	}

	

	@Override
	public void beginSession(IPSDELogicSession iPSDELogicEngineSession) {
		this.onBeginSession(iPSDELogicEngineSession);
	}
	
	protected void onBeginSession(IPSDELogicSession iPSDELogicEngineSession)  {
		
	}
	
	@Override
	public void endSession(IPSDELogicSession iPSDELogicEngineSession){
		this.onEndSession(iPSDELogicEngineSession);
	}
	
	protected void onEndSession(IPSDELogicSession iPSDELogicEngineSession) {
		
	}

//	@Override
//	public Object getParamObject(IPSDELogicSession iPSDELogicEngineSession){
//		return iPSDELogicEngineSession.getParamObject(this.getCodeName());
//	}

	@Override
	public Map<String, Object> any(IPSDELogicSession iPSDELogicEngineSession){
		Object objParam = this.getValue(iPSDELogicEngineSession);
		if(objParam instanceof IEntity) {
			return ((IEntity)objParam).any();
		}
		
		throw new PSModelEngineAddinException(this, String.format("未支持any操作"));
	}

//	@Override
//	public void set(iPSDELogicEngineSession iPSDELogicEngineSession, String name, String strValue) throws Throwable {
//		Object objParam = getParamObject(iPSDELogicEngineSession);
//		if(objParam instanceof IEntity) {
//			((IEntity)objParam).set(name, strValue);
//			return;
//		}
//		
//
//		if(objParam instanceof IEntity) {
//			((IEntity)objParam).set(name, strValue);
//			return;
//		}
//		
//		throw new PSModelEngineAddinException(this, String.format("逻辑参数[%1$s]未支持set操作", getCodeName()));
//	}

	@Override
	public void set(IPSDELogicSession iPSDELogicEngineSession, String name, Object objValue) {
		Object objParam = getValue(iPSDELogicEngineSession);
		if(objValue instanceof String) {
			//优先以字符串形式写入
			if(objParam instanceof IEntity) {
				((IEntity)objParam).set(name, (String)objValue);
				return;
			}
		}
		if(objParam instanceof IEntity) {
			((IEntity)objParam).set(name, objValue);
			return;
		}
		
		throw new PSModelEngineAddinException(this, String.format("未支持set操作"));
	}

	@Override
	public void reset(IPSDELogicSession iPSDELogicEngineSession, String name)  {
		Object objParam = getValue(iPSDELogicEngineSession);
		if(objParam instanceof IEntity) {
			((IEntity)objParam).reset(name);
			return;
		}
		throw new PSModelEngineAddinException(this, String.format("未支持reset操作"));
	}

	@Override
	public void resetAll(IPSDELogicSession iPSDELogicEngineSession) {
		Object objParam = getValue(iPSDELogicEngineSession);
		if(objParam instanceof IEntity) {
			((IEntity)objParam).resetAll();
			return;
		}
		throw new PSModelEngineAddinException(this, String.format("未支持resetAll操作"));
	}


	@Override
	public Object get(IPSDELogicSession iPSDELogicEngineSession, String name) {
		
		if(ObjectUtils.isEmpty(name)) {
			throw new PSModelEngineAddinException(this, String.format("未指定属性"));
		}
		
		Object objParam = getValue(iPSDELogicEngineSession);
		if(objParam instanceof IEntity) {
			return ((IEntity)objParam).get(name);
		}
		
		if(PARAM_TOTAL.equalsIgnoreCase(name)) {
			if(objParam instanceof IPage) {
				return ((IPage)objParam).getTotalElements();
			}
		}
		else if(PARAM_SIZE.equalsIgnoreCase(name)
				|| PARAM_LENGTH.equalsIgnoreCase(name)) {
			List list = asList(objParam);
			if(list != null) {
				return list.size();
			}
		}
		else {
			List list = asList(objParam);
			if(list != null) {
				int nPos = Integer.parseInt(name);
				if(nPos <0 || nPos >= list.size()) {
					throw new PSModelEngineAddinException(this, String.format("无效的位置[%1$s]",nPos));
				}
				return list.get(nPos);
			}
		}
			
		throw new PSModelEngineAddinException(this, String.format("未支持get[%1$s]操作", name));
	}

	@Override
	public boolean contains(IPSDELogicSession iPSDELogicEngineSession, String name) {
		Object objParam = getValue(iPSDELogicEngineSession);
		if(objParam instanceof IEntity) {
			return ((IEntity)objParam).contains(name);
		}
		throw new PSModelEngineAddinException(this, String.format("未支持contains操作"));
	}

	@Override
	public void copyTo(IPSDELogicSession iPSDELogicEngineSession, Object dstParam) {
		Object objParam = getValue(iPSDELogicEngineSession);
		if(objParam instanceof IEntity && dstParam instanceof IEntity) {
			((IEntity)objParam).copyTo((IEntity)dstParam);
			return;
		}
		throw new PSModelEngineAddinException(this, String.format("未支持copyTo操作"));
	}

	

	@Override
	public void copyTo(Object dstParam, List<String> fieldList, boolean bCopyIfNotExists)  {
		this.copyTo(PSDELogicSessionHolder.getCurrentMust(), dstParam, fieldList, bCopyIfNotExists);
	}
	
	@Override
	public void copyTo(IPSDELogicSession iPSDELogicEngineSession, Object dstParam, List<String> fieldList, boolean bCopyIfNotExists) {
		Object objParam = getValue(iPSDELogicEngineSession);
		if(objParam instanceof IEntity && dstParam instanceof IEntity) {
			IEntity srcEntity = (IEntity)objParam;
			IEntity dstEntity = (IEntity)dstParam;
			if(ObjectUtils.isEmpty(fieldList)) {
				if(bCopyIfNotExists) {
					if(srcEntity instanceof IEntityDTO) {
						((IEntityDTO)srcEntity).copyToIf(dstEntity);
					}
					else {
						throw new PSModelEngineAddinException(this, String.format("未支持copyTo操作"));
					}
				}
				else {
					srcEntity.copyTo(dstEntity);
				}
			}
			else {
				for(String field : fieldList) {
					if(!srcEntity.contains(field)) {
						continue;
					}
					
					if(bCopyIfNotExists) {
						if(dstEntity.contains(field)) {
							continue;
						}
					}
					
					dstEntity.set(field, srcEntity.get(field));
				}
			}
			return;
		}
		throw new PSModelEngineAddinException(this, String.format("未支持copyTo操作"));
	}




//	@Override
//	public Object getScriptObject(IPSDELogicEngineSession iPSDELogicEngineSession) throws Throwable {
//		if(this.iScriptDELogicParam == null){
//			this.iScriptDELogicParam = this.createScriptDELogicParam();
//		}
//		return this.iScriptDELogicParam;
//	}
//	
//	
//	
//	protected IScriptDELogicParam createScriptDELogicParam() {
//		return new ScriptDELogicParam(this);
//	}
	
	@Override
	public void bind(IPSDELogicSession iPSDELogicEngineSession, Object paramObject){
		iPSDELogicEngineSession.setParam(this.getPSDELogicParam(), paramObject);
	}


	@Override
	public void renew(IPSDELogicSession iPSDELogicEngineSession){
		iPSDELogicEngineSession.setParam(this.getPSDELogicParam(), null);
	}
	
	

	@Override
	public void append(IPSDELogicSession iPSDELogicEngineSession, int nPos, Object paramObject, int nSrcPos, int nSrcLength){
		Object obj = this.getValue(iPSDELogicEngineSession);
		if (!(obj instanceof List)) {
			throw new PSModelEngineAddinException(this, String.format("目标参数不是数据对象列表类型"));
		}
		
		List list = (List)obj;
		
		List srcList = asList(paramObject);
		if(srcList!=null) {
			int nLength = srcList.size();
			if(nSrcPos >= 0) {
				if(nSrcLength>0) {
					if(nSrcPos + nSrcLength > nLength) {
						throw new PSModelEngineAddinException(this, String.format("列表长度溢出"));
					}
					
					nLength = nSrcPos + nSrcLength;
				}
			}
			
			int nInsertPos = nPos;
			if(nPos > list.size() ) {
				throw new PSModelEngineAddinException(this, String.format("插入位置溢出"));
			}
			for(int i = nSrcPos; i< nLength; i++) {
				if(nInsertPos>=0) {
					list.add(nInsertPos, srcList.get(i));
					nInsertPos++;
				}
				else {
					list.add(srcList.get(i));
				}
			}
		}
		else {
			if(nPos >=0) {
				if(nPos > list.size() ) {
					throw new PSModelEngineAddinException(this, String.format("插入位置溢出"));
				}
				list.add(nPos, paramObject);
			}
			else {
				list.add(paramObject);
			}
		}
		
		//throw new PSModelEngineAddinException(this, String.format("逻辑参数[%1$s]未支持appendParamObject操作", getCodeName()));
	}

	@Override
	public void sort(IPSDELogicSession iPSDELogicEngineSession, String field, String strSortDir) {
		Object obj = this.getValue(iPSDELogicEngineSession);
		if (!(obj instanceof List)) {
			throw new PSModelEngineAddinException(this, String.format("目标参数不是数据对象列表类型"));
		}
		
		List list = (List)obj;
		
		boolean bSortDesc = "desc".equalsIgnoreCase(strSortDir);
		Collections.sort(list, new Comparator<Object>() {
			@Override
			public int compare(Object o1, Object o2) {
				IEntity e1 = (IEntity)o1;
				IEntity e2 = (IEntity)o2;
				Object v1 = e1.get(field);
				Object v2 = e2.get(field);
				
				if(v1 == null && v2 == null) {
					return 0;
				}
				
				if(v1 != null && v2 == null) {
					return 1;
				}
				
				if(v1 == null && v2 != null) {
					return -1;
				}
				
				return (int)DataTypeUtils.compare(DataTypeUtils.getObjectDataType(v1), v1, v2);
			}
		});
		
		if(bSortDesc) {
			Collections.reverse(list);
		}
		
		//throw new PSModelEngineAddinException(this, String.format("逻辑参数[%1$s]未支持sortParamObject操作", getCodeName()));
	}
	
	@Override
	public int count(IPSDELogicSession iPSDELogicEngineSession) {
		
		Object obj = this.getValue(iPSDELogicEngineSession);
		if(obj == null) {
			return 0;
		}
		
		if (!(obj instanceof List)) {
			throw new PSModelEngineAddinException(this, String.format("未支持count操作"));
		}
		
		return ((List)obj).size();
		
	}

	


	@Override
	public Object aggregate(IPSDELogicSession iPSDELogicEngineSession, String field, String strAggMode) {
	
		Object obj = this.getValue(iPSDELogicEngineSession);
		if (!(obj instanceof List)) {
			throw new PSModelEngineAddinException(this, String.format("未支持aggregate操作"));
		}
		
		try {
			return PSDELogicEntityListParamAddin.aggregate(strAggMode, (List)obj, field);
		}
		catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("aggregate操作发生异常，%1$s", ex.getMessage()), ex);
		}
	}
	
	@Override
	public Object aggregate(String field, String strAggMode) {
	
		return this.aggregate(PSDELogicSessionHolder.getCurrentMust(), field, strAggMode);
	}
	
	
	@Override
	public void debug(IPSDELogicSession iPSDELogicEngineSession, Map<String, Object> data) {
		Object objValue = null;
		try {
			objValue = iPSDELogicEngineSession.getParam(this.getPSDELogicParam(), true);
			
		}
		catch(Throwable ex) {
			data.put("info", String.format("获取逻辑参数[%1$s]实际值发生异常，%2$s", this.getCodeName(), ex.getMessage()));
		}
		if(objValue == null) {
			data.put("data", null);
		}
		else {
			try {
				Object objData = this.getUtil().serialize(objValue);
				if(objData instanceof String) {
					data.put("data", (String)objData);
				}
				else {
					data.put("data", objData.toString());
				}
			}
			catch(Throwable ex) {
				if(objValue instanceof String) {
					data.put("data", (String)objValue);
				}
				else {
					data.put("data", objValue.toString());
				}
			}
		}
		
	}
	
	
	@Override
	public Object getValue(IPSDELogicSession iPSDELogicEngineSession){
		try {
			return iPSDELogicEngineSession.getParam(this.getPSDELogicParam());
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
	}
	
	@Override
	public Object getValue() {
		return this.getValue(PSDELogicSessionHolder.getCurrentMust());
	}
	
	
	
	
	@Override
	public Map<String, Object> any(){
		return this.any(PSDELogicSessionHolder.getCurrentMust());
	}


	@Override
	public void set(String name, Object objValue){
		this.set(PSDELogicSessionHolder.getCurrentMust(), name, objValue);
	}


	@Override
	public void reset(String name) {
		this.reset(PSDELogicSessionHolder.getCurrentMust(), name);
	}


	@Override
	public void resetAll() {
		this.resetAll(PSDELogicSessionHolder.getCurrentMust());
	}


	@Override
	public void copyTo(Object dstParam) {
		this.copyTo(PSDELogicSessionHolder.getCurrentMust(), dstParam);
	}


	@Override
	public Object get(String name) {
		return this.get(PSDELogicSessionHolder.getCurrentMust(), name);
	}


	@Override
	public boolean contains(String name) {
		return this.contains(PSDELogicSessionHolder.getCurrentMust(), name);
	}


	@Override
	public void bind(Object paramObject) {
		this.bind(PSDELogicSessionHolder.getCurrentMust(), paramObject);
	}


	@Override
	public void renew() {
		this.renew(PSDELogicSessionHolder.getCurrentMust());
	}


	@Override
	public void append(int nPos, Object paramObject, int nSrcPos, int nSrcLength) {
		this.append(PSDELogicSessionHolder.getCurrentMust(), nPos, paramObject, nSrcPos, nSrcLength);
	}


	@Override
	public void sort(String field, String strSortDir) {
		this.sort(PSDELogicSessionHolder.getCurrentMust(), field, strSortDir);
	}


	@Override
	public int count() {
		return this.count(PSDELogicSessionHolder.getCurrentMust());
	}


	/**
	 * 将传入对象转化为列表对象
	 * @param object
	 * @return
	 */
	public static List asList(Object object) {
		if(object instanceof List) {
			return (List)object;
		}
		
		if(object instanceof IPage) {
			return ((IPage)object).getContent();
		}
		
		return null;
	}
	
	/**
	 * 将传入对象转化为Map对象
	 * @param object
	 * @return
	 */
	public static Map asMap(Object object) {
		if(object instanceof Map) {
			return (Map)object;
		}

		return null;
	}
	
	
	/**
	 * 将传入对象转化为列表对象
	 * @param object
	 * @return
	 */
	public static Object[] asObjects(Object object) {
		
		if(object == null) {
			return null;
		}
		
		List list = asList(object);
		if(list != null) {
			return list.toArray(new Object[list.size()]);
		}
		
		return new Object[] {object};
	}
	
	
	/**
	 *  计算列表指定属性的最大值
	 * @param list
	 * @param field
	 * @param iDataEntityRuntime
	 * @return
	 * @throws Throwable
	 */
	public static Object max(List list, String field) throws Exception{
		if( list == null || list.size() == 0 ) {
			return null;
		}
		
		Object maxValue = null;
		for(Object objItem : list) {
			if(!(objItem instanceof IEntity)) {
				throw new Exception(String.format("列表项不是数据对象类型"));
			}
			IEntity iEntity = (IEntity)objItem;
			Object objValue = iEntity.get(field);
			if(objValue == null) {
				continue;
			}
			if(maxValue == null) {
				maxValue = objValue;
			}
			else {
				if(DataTypeUtils.compare(DataTypeUtils.getObjectDataType(maxValue), maxValue, objValue)<0) {
					maxValue = objValue ;
				}
			}
		}
		
		return maxValue;
	}
	
	
	/**
	 * 计算列表指定属性的最小值
	 * @param list
	 * @param field
	 * @param iDataEntityRuntime
	 * @return
	 */
	public static Object min(List list, String field) throws Exception{
		if( list == null || list.size() == 0 ) {
			return null;
		}
		
		Object minValue = null;
		for(Object objItem : list) {
			if(!(objItem instanceof IEntity)) {
				throw new Exception(String.format("列表项不是数据对象类型"));
			}
			IEntity iEntity = (IEntity)objItem;
			Object objValue = iEntity.get(field);
			if(minValue == null) {
				minValue = objValue;
			}
			else {
				if(DataTypeUtils.compare(DataTypeUtils.getObjectDataType(minValue), minValue, objValue)>0) {
					minValue = objValue ;
				}
			}
		}
		
		return minValue;
	}
	
	
	/**
	 * 计算列表指定属性的合计值
	 * @param list
	 * @param field
	 * @param iDataEntityRuntime
	 * @return
	 * @throws Throwable
	 */
	public static java.math.BigDecimal sum(List list, String field) throws Exception{
		if( list == null || list.size() == 0 ) {
			return null;
		}
		
		java.math.BigDecimal sumValue = null;
		for(Object objItem : list) {
			if(!(objItem instanceof IEntity)) {
				throw new Exception(String.format("列表项不是数据对象类型"));
			}
			IEntity iEntity = (IEntity)objItem;
			Object objValue = iEntity.get(field);
			java.math.BigDecimal curValue = DataTypeUtils.getBigDecimalValue(objValue, null);
			if(curValue == null) {
				continue;
			}
			if(sumValue == null) {
				sumValue = curValue;
			}
			else {
				sumValue = sumValue.add(curValue);
			}
		}
		
		return sumValue;
	}
	
	
	
	/**
	 * 计算列表指定属性的平均值
	 * @param list
	 * @param field
	 * @param iDataEntityRuntime
	 * @return
	 * @throws Throwable
	 */
	public static java.math.BigDecimal avg(List list, String field) throws Exception{
		if( list == null || list.size() == 0 ) {
			return null;
		}
		
		java.math.BigDecimal sumvalue = sum(list, field);
		if(sumvalue == null) {
			return null;
		}
		
		return sumvalue.divide(BigDecimal.valueOf(list.size()));
	}
	

	/**
	 *  指定计算类型对列表的属性值进行计算
	 * @param calcType
	 * @param list
	 * @param field
	 * @param iDataEntityRuntime
	 * @return
	 * @throws Throwable
	 */
	public static Object aggregate(String calcType, List list, String field) throws Exception{
		
		if(DER1NDEFMapType.COUNT.value.equalsIgnoreCase(calcType)) {
			if( list == null ) {
				return 0;
			}
			return list.size();
		}
		
		if(DER1NDEFMapType.MAX.value.equalsIgnoreCase(calcType)){
			return max(list, field);
		}
		
		if(DER1NDEFMapType.MIN.value.equalsIgnoreCase(calcType)){
			return min(list, field);
		}
		
		if(DER1NDEFMapType.SUM.value.equalsIgnoreCase(calcType)){
			return sum(list, field);
		}
		
		if(DER1NDEFMapType.AVG.value.equalsIgnoreCase(calcType)){
			return avg(list, field);
		}
		
		
		throw new Exception(String.format("无法识别的计算类型[%1$s]", calcType));
	}
	
	
}
