package net.ibizsys.model.engine.dataentity.logic;

import java.util.ArrayList;
import java.util.List;

import org.springframework.util.ObjectUtils;

import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.engine.plugin.PSModelEngineAddin2Base;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;

public abstract class PSDELogicNodeAddinBase<E extends IPSDELogicEngine<?>, M extends IPSDELogicNode> extends PSModelEngineAddin2Base<E, M> implements IPSDELogicNodeAddin<E, M> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSDELogicNodeAddinBase.class);
	
	
	//private Map<Integer, IDELogicScriptNodeRuntime> deLogicScriptNodeRuntimeMap = new HashMap<Integer, IDELogicScriptNodeRuntime>();
//	@Override
//	protected IPSDELogicNode getAddinData() {
//		return (IPSDELogicNode)super.getAddinData();
//	}
//	
	//@Override
	protected M getPSDELogicNode() {
		return this.getAddinData();
	}
	
	@Override
	public String getName() {
		return this.getAddinData().getName();
	}
	
	@Override
	public String getFullName() {
		return String.format("逻辑节点[%1$s]", this.getName());
	}
	
	@Override
	public void execute(IPSDELogicSession iPSDELogicEngineSession) {
		try {
			onExecute(iPSDELogicEngineSession);
		}
		catch (Throwable ex) {
			if(ex instanceof PSModelEngineAddinException) {
				throw (PSModelEngineAddinException) ex;
			}
			throw new PSModelEngineAddinException(this, ex.getMessage(), ex);
		}
	}

	
	protected void onExecute(IPSDELogicSession iPSDELogicEngineSession) throws Throwable{
		throw new Exception("没有实现");
	}

	
	protected Object calcPSDELogicNodeParamValue(IPSDELogicSession iPSDELogicEngineSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable{
		return iPSDELogicEngineSession.getNodeParamValue(iPSDELogicNodeParam);
	}
	
	protected List getNodeParams(IPSDELogicSession iPSDELogicEngineSession, IPSDELogicNode iPSDELogicNode) throws Throwable {
		java.util.List<net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam> list = iPSDELogicNode.getPSDELogicNodeParams();
		if(ObjectUtils.isEmpty(list)) {
			return null;
		}
		List params = new ArrayList<>();
		for(IPSDELogicNodeParam iPSDELogicNodeParam : list) {
			params.add(this.calcPSDELogicNodeParamValue(iPSDELogicEngineSession, iPSDELogicNodeParam));
		}
		return params;
	}
	
	
	
	
//	protected Object calcDELogicNodeParamValue(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iPSDELogicEngineSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable{
//		
//		if(DELogicPrepareParamValueTypes.SRCDLPARAM.equals(iPSDELogicNodeParam.getSrcValueType())) {
//			IDELogicParamRuntime srcDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
//			if(StringUtils.isEmpty(iPSDELogicNodeParam.getSrcFieldName())) {
//				//throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定源属性名称", iPSDELogicNodeParam.getName()));
//				return srcDELogicParamRuntime.getReal(iPSDELogicEngineSession);
//			}
//		//	IEntity srcEntity = iPSDELogicEngineSession.getParam(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName());
//		//	return srcEntity.get(iPSDELogicNodeParam.getSrcFieldName().toLowerCase());
//			
//			return srcDELogicParamRuntime.get(iPSDELogicEngineSession, iPSDELogicNodeParam.getSrcFieldName().toLowerCase());
//		}
//		
//		if(DELogicPrepareParamValueTypes.NULLVALUE.equals(iPSDELogicNodeParam.getSrcValueType())) {			
//			return null;
//		}
//
//		if(DELogicPrepareParamValueTypes.SRCVALUE.equals(iPSDELogicNodeParam.getSrcValueType())) {			
//			return iPSDELogicNodeParam.getSrcValue();
//		}
//		
//		if(DELogicPrepareParamValueTypes.SESSION.equals(iPSDELogicNodeParam.getSrcValueType())) {	
//			if(StringUtils.isEmpty(iPSDELogicNodeParam.getSrcFieldName())) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定源属性名称", iPSDELogicNodeParam.getName()));
//			}
//			
//			if(iPSDELogicEngineSession.getUserContext() == null) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("用户上下文对象无效"));
//			}
//			
//			return iPSDELogicEngineSession.getUserContext().getSessionParam(iPSDELogicNodeParam.getSrcFieldName());
//		}
//		
//		
//		if(DELogicPrepareParamValueTypes.APPLICATION.equals(iPSDELogicNodeParam.getSrcValueType())) {	
//			if(StringUtils.isEmpty(iPSDELogicNodeParam.getSrcFieldName())) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定源属性名称", iPSDELogicNodeParam.getName()));
//			}
//			
//			// 系统全局对象属性
//			return iDELogicRuntimeContext.getSystemRuntime().getGlobalParam(iPSDELogicNodeParam.getSrcFieldName());
//		}
//		
//		if(DELogicPrepareParamValueTypes.EXPRESSION.equals(iPSDELogicNodeParam.getSrcValueType())) {	
//			if(StringUtils.isEmpty(iPSDELogicNodeParam.getExpression())) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定表达式", iPSDELogicNodeParam.getName()));
//			}
//			IDELogicScriptNodeRuntime iDELogicScriptNodeRuntime = this.getDEScriptLogicRuntime(iDELogicRuntimeContext, iPSDELogicNodeParam.getExpression(), IDELogicScriptNodeRuntime.MODE_EXPRESSION, false);
//			return iDELogicScriptNodeRuntime.execute(iDELogicRuntimeContext, iPSDELogicEngineSession, iPSDELogicNodeParam);
//		}
//			
//		if(DELogicPrepareParamValueTypes.COUNT.equals(iPSDELogicNodeParam.getSrcValueType())) {	
//			IDELogicParamRuntime srcDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
//			return srcDELogicParamRuntime.count(iPSDELogicEngineSession);
//		}
//		
//		if(DELogicPrepareParamValueTypes.AGGREGATION.equals(iPSDELogicNodeParam.getSrcValueType())) {	
//			IDELogicParamRuntime srcDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
//			
//			if(StringUtils.isEmpty(iPSDELogicNodeParam.getSrcFieldName())) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定源属性名称", iPSDELogicNodeParam.getName()));
//			}
//			
//			if(StringUtils.isEmpty(iPSDELogicNodeParam.getAggMode())) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定聚合模式", iPSDELogicNodeParam.getName()));
//			}
//			
//			return srcDELogicParamRuntime.aggregate(iPSDELogicEngineSession, iPSDELogicNodeParam.getSrcFieldName(), iPSDELogicNodeParam.getAggMode());
//		}
//		
//		if(DELogicPrepareParamValueTypes.TRANSLATOR.equals(iPSDELogicNodeParam.getSrcValueType())) {	
//			
//			ISysTranslatorRuntime iSysTranslatorRuntime = iDELogicRuntimeContext.getSystemRuntime().getSysTranslatorRuntime(iPSDELogicNodeParam.getPSSysTranslatorMust());
//			
//			IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
//			if(StringUtils.isEmpty(iPSDELogicNodeParam.getDstFieldName())) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定目标属性名称", iPSDELogicNodeParam.getName()));
//			}
//			
//			Object objValue = dstDELogicParamRuntime.get(iPSDELogicEngineSession, iPSDELogicNodeParam.getDstFieldName());
//			
//			Object objEntity = dstDELogicParamRuntime.getParamObject(iPSDELogicEngineSession);
//			IEntityBase iEntityBase = null;
//			if(objEntity instanceof IEntityBase) {
//				iEntityBase = (IEntityBase)objEntity;
//			}
//			
//			IDataEntityRuntime iDataEntityRuntime = dstDELogicParamRuntime.getDataEntityRuntime();
//			IPSDEField iPSDEField = null;
//			if(iDataEntityRuntime!=null) {
//				iPSDEField = iDataEntityRuntime.getPSDEField(iPSDELogicNodeParam.getDstFieldName(), true);
//			}
//			
//			return iSysTranslatorRuntime.translate(objValue, true, iEntityBase, iPSDEField, iDataEntityRuntime);
//		}
//		
//		if(DELogicPrepareParamValueTypes.SEQUENCE.equals(iPSDELogicNodeParam.getSrcValueType())) {
//			ISysSequenceRuntime iSysSequenceRuntime = iDELogicRuntimeContext.getSystemRuntime().getSysSequenceRuntime(iPSDELogicNodeParam.getPSSysSequenceMust());
//			
//			IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
//			if(StringUtils.isEmpty(iPSDELogicNodeParam.getDstFieldName())) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定目标属性名称", iPSDELogicNodeParam.getName()));
//			}
//			
//			Object objEntity = dstDELogicParamRuntime.getParamObject(iPSDELogicEngineSession);
//			IEntityBase iEntityBase = null;
//			if(objEntity instanceof IEntityBase) {
//				iEntityBase = (IEntityBase)objEntity;
//			}
//			
//			IDataEntityRuntime iDataEntityRuntime = dstDELogicParamRuntime.getDataEntityRuntime();
//			IPSDEField iPSDEField = null;
//			if(iDataEntityRuntime!=null) {
//				iPSDEField = iDataEntityRuntime.getPSDEField(iPSDELogicNodeParam.getDstFieldName(), true);
//			}
//			
//			return iSysSequenceRuntime.get(iEntityBase, iPSDEField, iDataEntityRuntime);
//		}
//		
//		
//		throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]源值类型[%2$s]未支持", iPSDELogicNodeParam.getName(), iPSDELogicNodeParam.getSrcValueType()));
//	}
//	
//	
//	/**
//	 * 建立实体脚本逻辑运行时对象
//	 * @param strScriptCode
//	 * @return
//	 */
//	public IDELogicScriptNodeRuntime createDELogicScriptNodeRuntime(String strScriptCode, String strMode) {
//		return new DELogicScriptNodeRuntime();
//	}
//	
//	protected IDELogicScriptNodeRuntime getDEScriptLogicRuntime(IDELogicRuntimeContext iDELogicRuntimeContext, String strScriptCode, String strMode, boolean bTryMode) {
//		String strLogicTag = String.format("%1$s|%2$s", strScriptCode, strMode);
//		IDELogicScriptNodeRuntime iDELogicScriptNodeRuntime = this.deLogicScriptNodeRuntimeMap.get(strLogicTag.hashCode());
//		if(iDELogicScriptNodeRuntime != null || bTryMode ) {
//			return iDELogicScriptNodeRuntime;
//		}
//			
//		iDELogicScriptNodeRuntime = createDELogicScriptNodeRuntime(strScriptCode, strMode);
//		try {
//			iDELogicScriptNodeRuntime.init(iDELogicRuntimeContext.getSystemRuntime().getSystemRTScriptContext(), this, strScriptCode, strMode);
//		} catch (Exception e) {
//			log.error(String.format("初始化实体处理逻辑脚本节点逻辑运行时对象发生异常，%1$s",e.getMessage()),e);
//			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), String.format("初始化实体处理逻辑脚本节点逻辑运行时对象发生异常，%1$s",e.getMessage()), e);
//		}
//		this.deLogicScriptNodeRuntimeMap.put(strLogicTag.hashCode(), iDELogicScriptNodeRuntime);
//		return iDELogicScriptNodeRuntime;
//	}
	
}
	
