package net.ibizsys.model.engine.dataentity.logic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.INavigateContext;
import net.ibizsys.model.engine.util.NavigateContext;
import net.ibizsys.model.engine.util.NavigateContextHolder;

/**
 * 处理逻辑应用上下文参数对象
 * 
 * @author lionlau
 *
 */
public class PSDELogicNavigateContextParamAddin extends PSDELogicSysParamAddinBase {

	private static final Log log = LogFactory.getLog(PSDELogicNavigateContextParamAddin.class);
	
	@Override
	protected void onBeginSession(IPSDELogicSession iPSDELogicEngineSession) {
		if(this.getPSDELogicParam().isCloneParam()) {
			INavigateContext backupNavigateContext = NavigateContextHolder.getCurrent();
			//备份参数
			iPSDELogicEngineSession.setParam("_BACKUP_" + this.getCodeName(), backupNavigateContext);
			
			//新建变量
			INavigateContext iNavigateContext = new NavigateContext(backupNavigateContext);
			NavigateContextHolder.setCurrent(iNavigateContext);
		}
		
		super.onBeginSession(iPSDELogicEngineSession);
	}

	@Override
	protected void onEndSession(IPSDELogicSession iPSDELogicEngineSession) {
		if(this.getPSDELogicParam().isCloneParam()) {
			try {
				Object objNavigateContext = iPSDELogicEngineSession.getParam("_BACKUP_" + this.getCodeName(), true);
				INavigateContext backupNavigateContext = null;
				if(objNavigateContext instanceof INavigateContext) {
					backupNavigateContext = (INavigateContext)objNavigateContext;
				}
				NavigateContextHolder.setCurrent(backupNavigateContext);
			}
			catch(Throwable ex) {
				log.error(ex);
			}
		}
		super.onEndSession(iPSDELogicEngineSession);
	}

	@Override
	public Object getValue(IPSDELogicSession iPSDELogicEngineSession){
		try {
			return NavigateContextHolder.getCurrentMust();
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
	}

}
