package net.ibizsys.model.engine.dataentity.logic;

import java.util.List;

import net.ibizsys.model.dataentity.logic.IPSDEMergeParamLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;

/**
 * 实体合并逻辑数组参数节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicMergeParamNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEMergeParamLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEMergeParamLogic getPSDELogicNode() {
		return (IPSDEMergeParamLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEMergeParamLogic iPSDEMergeParamLogic = getPSDELogicNode();
		
		IPSDELogicParamAddin srcPSDELogicParamAddin = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEMergeParamLogic.getSrcPSDELogicParamMust().getCodeName(), false);
		IPSDELogicParamAddin dstPSDELogicParamAddin = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEMergeParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		
		//获取源参数
		Object objParam = srcPSDELogicParamAddin.getValue(iPSDELogicSession);
		List srcList = PSDELogicParamAddin.asList(objParam);
		if(srcList == null) {
			throw new PSModelEngineAddinException(this, String.format("指定列表参数[%1$s]类型不正确", iPSDEMergeParamLogic.getSrcPSDELogicParamMust().getCodeName()));
		}
		objParam = dstPSDELogicParamAddin.getValue(iPSDELogicSession);
		List dstList = PSDELogicParamAddin.asList(objParam);
		if(dstList == null) {
			throw new PSModelEngineAddinException(this, String.format("指定列表参数[%1$s]类型不正确", iPSDEMergeParamLogic.getDstPSDELogicParamMust().getCodeName()));
		}
		
//		Map<String, String> groupFieldMap = new LinkedHashMap<String, String>();
//		List<IPSDELogicNodeParam> psDELogicNodeParamList = iPSDEMergeParamLogic.getPSDELogicNodeParams();
//		if(!ObjectUtils.isEmpty(psDELogicNodeParamList)) {
//			for(IPSDELogicNodeParam psDELogicNodeParam : psDELogicNodeParamList) {
//				if(!DELogicNodeParamTypes.MERGEMAPPARAM.equals(psDELogicNodeParam.getParamAction())) {
//					continue;
//				}
//				
//				if(StringUtils.hasLength(psDELogicNodeParam.getAggMode()) 
//						&& !psDELogicNodeParam.getAggMode().equals(AggMode.GROUP)) {
//					continue;
//				}
//				
//				String strSrcField = psDELogicNodeParam.getSrcFieldName();
//				if(!StringUtils.hasLength(strSrcField)) {
//					throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]合并映射参数[%2$s]未指定源属性", iPSDELogicNode.getName(), psDELogicNodeParam.getName()));
//				}
//				String strDstField = psDELogicNodeParam.getDstFieldName();
//				if(!StringUtils.hasLength(strDstField)) {
//					strDstField = strSrcField;
//				}
//				
//				groupFieldMap.put(strSrcField, strDstField);
//			}
//		}
//		
//		if(ObjectUtils.isEmpty(groupFieldMap)) {
//			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]未指定合并映射参数", iPSDELogicNode.getName()));
//		}
//		
//		Map<String, IEntity> srcMap = new LinkedHashMap<>();
//		Map<String, IEntity> dstMap = new LinkedHashMap<>();
//		
//		for(Object item : srcList) {
//			
//			if(!(item instanceof IEntity)) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]列表参数[%2$s]项类型不正确", iPSDELogicNode.getName(), iPSDEMergeParamLogic.getSrcPSDELogicParamMust().getCodeName()));
//			}
//			
//			IEntity iEntity = (IEntity)item;
//			
//			//计算分组项
//			Object[] keys = new Object[groupFieldMap.size()];
//			int nIndex = 0;
//			for(java.util.Map.Entry<String, String> groupItem : groupFieldMap.entrySet()) {
//				keys[nIndex] = DataTypeUtils.getStringValue(iEntity.get(groupItem.getKey()), null);
//				nIndex ++;
//			}
//			
//			String strGroupKey = KeyValueUtils.genUniqueId(keys);
//			if(srcMap.containsKey(strGroupKey)) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]列表参数[%2$s]出现重复分组项", iPSDELogicNode.getName(), iPSDEMergeParamLogic.getSrcPSDELogicParamMust().getCodeName()));
//			}
//			
//			srcMap.put(strGroupKey, iEntity);
//			
//		}
//		
//		for(Object item : dstList) {
//			
//			if(!(item instanceof IEntity)) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]列表参数[%2$s]项类型不正确", iPSDELogicNode.getName(), iPSDEMergeParamLogic.getDstPSDELogicParamMust().getCodeName()));
//			}
//			
//			IEntity iEntity = (IEntity)item;
//			
//			//计算分组项
//			Object[] keys = new Object[groupFieldMap.size()];
//			int nIndex = 0;
//			for(java.util.Map.Entry<String, String> groupItem : groupFieldMap.entrySet()) {
//				keys[nIndex] = DataTypeUtils.getStringValue(iEntity.get(groupItem.getValue()), null);
//				nIndex ++;
//			}
//			
//			String strGroupKey = KeyValueUtils.genUniqueId(keys);
//			if(dstMap.containsKey(strGroupKey)) {
//				throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]列表参数[%2$s]出现重复分组项", iPSDELogicNode.getName(), iPSDEMergeParamLogic.getDstPSDELogicParamMust().getCodeName()));
//			}
//			
//			dstMap.put(strGroupKey, iEntity);
//			
//		}
//		
//		//根据合并模式进行处理
//		String strMergeMode = iPSDEMergeParamLogic.getMergeMode();
//		if(DELNMergeParamMode.DEFAULT.equals(strMergeMode)) {
//			
//		}
//
//		iPSDELogicSession.setLastReturn(null);
		
		throw new Exception("没有实现");
	}
	
}
