package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IEntity;
import net.ibizsys.model.engine.util.ISearchContextBase;

/**
 * 数据查询过滤器参数运行时对象实现
 * 
 * @author lionlau
 *
 */
public class PSDELogicFilterParamAddin extends PSDELogicParamAddinBase {

	
	
	@Override
	public Object getValue(IPSDELogicSession iDELogicSession) {
		Object object;
		try {
			object = iDELogicSession.getParam(this.getPSDELogicParam(), true);
			if (object != null) {
				// 检查类型是否正确
				if (!(object instanceof IEntity)) {
					throw new Exception(String.format("值不是搜索过滤器类型"));
				}
				return object;
			}
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
		
		// 新建
		if (this.getPSDELogicParam().getParamPSDataEntity() == null) {
			object = this.getUtil().createSearchContext();
		} else {
			object = this.getUtil().createSearchContextDTO(this.getPSDELogicParam().getParamPSDataEntity());
		}
		iDELogicSession.setParam(this.getPSDELogicParam(), object);
		return object;
	}

	@Override
	public void bind(IPSDELogicSession iDELogicSession, Object paramObject) {
		if (paramObject != null) {
			// 检查类型是否正确
			if (!(paramObject instanceof ISearchContextBase)) {
				throw new PSModelEngineAddinException(this, String.format("逻辑参数无法绑定非搜索过滤器类型参数"));
			}
		}
		super.bind(iDELogicSession, paramObject);
	}
	

//	@Override
//	public void set(IPSDELogicSession iDELogicSession, String strName, Object objValue) throws Throwable {
//		Object searchContext = this.getParamObject(iDELogicSession);
//		ISearchContextDTO iSearchContextDTO = null;
//		if(searchContext instanceof ISearchContextDTO) {
//			iSearchContextDTO = (ISearchContextDTO)searchContext;
//		}
//		
//		if(iSearchContextDTO == null || objValue == null) {
//			super.set(iDELogicSession, strName, objValue);
//			return;
//		}
//		
//		if(net.ibizsys.central.util.ISearchContext.PARAM_PAGE.equalsIgnoreCase(strName)) {
//			int nPage = Integer.valueOf(objValue.toString());
//			if (nPage < 0) {
//				nPage = 0;
//			}
//			
//			Pageable lastPageable = iSearchContextDTO.getPageable();
//			if(lastPageable == null) {
//				iSearchContextDTO.setPageable(PageRequest.of(nPage, SearchContextDTO.getMaxSize(), 0));
//			}
//			else {
//				iSearchContextDTO.setPageable(PageRequest.of(nPage, lastPageable.getPageSize(), lastPageable.getOffset()));
//			}
//			return;
//		}
//		
//		if(net.ibizsys.central.util.ISearchContext.PARAM_SIZE.equalsIgnoreCase(strName)) {
//			int nSize = Integer.valueOf(objValue.toString());
//			if (nSize <= 0) {
//				nSize = ISearchContextDTO.DEFAULTPAGESIZE;
//			}
//			
//			Pageable lastPageable = iSearchContextDTO.getPageable();
//			if(lastPageable == null) {
//				iSearchContextDTO.setPageable(PageRequest.of(ISearchContextDTO.STARTPAGE, nSize));
//			}
//			else {
//				iSearchContextDTO.setPageable(PageRequest.of(lastPageable.getPageNumber(), nSize, lastPageable.getOffset()));
//			}
//			return;
//		}
//		
//		if(net.ibizsys.central.util.ISearchContext.PARAM_OFFSET.equalsIgnoreCase(strName)) {
//			int nOffset = Integer.valueOf(objValue.toString());
//			if (nOffset < 0) {
//				nOffset = 0;
//			}
//			
//			Pageable lastPageable = iSearchContextDTO.getPageable();
//			if(lastPageable == null) {
//				iSearchContextDTO.setPageable(PageRequest.of(ISearchContextDTO.STARTPAGE, ISearchContextDTO.DEFAULTPAGESIZE, nOffset));
//			}
//			else {
//				iSearchContextDTO.setPageable(PageRequest.of(lastPageable.getPageNumber(), lastPageable.getPageSize(), nOffset));
//			}
//			return;
//		}
//		
//		if(net.ibizsys.central.util.ISearchContext.PARAM_SORT.equalsIgnoreCase(strName)) {
//			String strSortInfo = (String) objValue;
//			strSortInfo = strSortInfo.trim();
//			iSearchContextDTO.setPageSort(strSortInfo);
//			return ;
//		}
//		
//		if(net.ibizsys.central.util.ISearchContext.PARAM_QUERY.equalsIgnoreCase(strName)) {
//			String strQuery = objValue.toString();
//			strQuery = strQuery.trim();
//			
//			SearchContextDTO.addSearchQuickCond(iSearchContextDTO, strQuery);
//			return ;
//		}
//		
//		if(iSearchContextDTO.getDEMethodDTORuntime()!=null) {
//			IPSDEMethodDTOField iPSDEMethodDTOField = iSearchContextDTO.getDEMethodDTORuntime().getPSDEMethodDTOField(strName, true);
//			if(iPSDEMethodDTOField!=null) {
//				SearchContextDTO.addSearchFieldCond(iSearchContextDTO, strName, objValue);
//				return;
//			}
//		}
//		
//		iSearchContextDTO.set(strName, objValue);
//		return;
//	}
}
